
export type ExternalSystem = {
    identifier?: string;
    description?: string;
    authKind?: ExternalSystem.AuthKind;
    properties?: Record<string, string>;
};
export namespace ExternalSystem {
    export type AuthKind =  "NONE" |  "SIMPLE_CREDENTIALS" |  "API_KEY" |  "OPEN_ID_PKCE";
    export const AuthKind : {
        readonly NONE: AuthKind,
        readonly SIMPLE_CREDENTIALS: AuthKind,
        readonly API_KEY: AuthKind,
        readonly OPEN_ID_PKCE: AuthKind
    };

}
