import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './CredentialsClient.json';

export class CredentialsClient extends ApiEndPoint {
    version = "5.4.2696";
    constructor(apiKey, domainUid , base = '') {
        super(apiKey, base + '/api/credentials/{domainUid}');
        this.domainUid = domainUid;
        this.base = this.base.replace('{domainUid}', encodeURIComponent(domainUid));
    }
    async getObfuscatedUserCredentials(userUid,  __fetchOptions = {}) {
        let __path = this.base + '/user/{userUid}';
        __path = __path.replace('{userUid}', encodeURIComponent(userUid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async removeUserCredential(userUid, credentialId,  __fetchOptions = {}) {
        let __path = this.base + '/user/{userUid}/{credentialId}';
        __path = __path.replace('{userUid}', encodeURIComponent(userUid));
        __path = __path.replace('{credentialId}', encodeURIComponent(credentialId));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('DELETE', 'application/json', __fetchOptions);
		return this.__fetchVoid(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
