export type JobExitStatus =  "IN_PROGRESS" |  "SUCCESS" |  "COMPLETED_WITH_WARNINGS" |  "FAILURE" |  "UNKNOWN" |  "INTERRUPTED";
export const JobExitStatus : {
    /**
     * Job is running
     */
    readonly IN_PROGRESS: JobExitStatus,
    /**
     * Successful execution
     */
    readonly SUCCESS: JobExitStatus,
    /**
     * The task reported some problems but the work was accomplished.
     */
    readonly COMPLETED_WITH_WARNINGS: JobExitStatus,
    /**
     * The task failed. Most of its work was not done.
     */
    readonly FAILURE: JobExitStatus,
    /**
     * The task never run or all records was purge.
     */
    readonly UNKNOWN: JobExitStatus,
    /**
     * The task has been interrupted.
     */
    readonly INTERRUPTED: JobExitStatus
};
