export type IdentityDescription = {
    /**
     * {@link Mailbox} uid
     */
    mbox?: string;
    /**
     * identity id (work, personal, free string)
     */
    id?: string;
    /**
     * the email that will be used to send the e-mail when using this identity.
     */
    email?: string;
    emailIsDefault?: boolean;
    /**
     * the identity name that will be used in the from header of the mail alongside
     * with {@link #email}
     */
    name?: string;
    isDefault?: boolean;
    displayname?: string;
    signature?: string;
    /**
     * @see {@link Mailbox#name}
     */
    mboxName?: string;
};
