
import { SignatureFormat } from "./SignatureFormat"; 
/**
 * A mail identity that can endorsed by a user when sending an email
 */
export type Identity = {
    /**
     * the email that will be used to send the e-mail when using this identity.
     * This e-mail must :
     * <ul>
     * <li>Exist</li>
     * <li>Be associated to the {@link Mailbox} owner of the identity</li>
     * </ul>
     */
    email?: string;
    /**
     * the signature mime type. The signature can either be
     * {@link SignatureFormat.PLAIN} or {@link SignatureFormat.HTML}.
     */
    format?: SignatureFormat;
    /**
     * the mail signature associated to this identity. The signature will be
     * added at the end of the e-mail when using this identity. Depending on
     * {@link #format} the signature will be interpreted as text/plain or as
     * text/html.
     */
    signature?: string;
    /**
     * the identity display name. The identity display name is an additional
     * name used to describe the identity. This name will not be sent along with
     * the email, and is only used to identity identities with same
     * {@link #email} and same {@Link #name}.
     */
    displayname?: string;
    /**
     * the identity name that will be used in the from header of the mail
     * alongside with {@link #email}.
     */
    name?: string;
    /**
     * if this identity is the default one. There is only one default identity
     */
    isDefault?: boolean;
    /**
     * the folder path to store mail when sending a mail using this identity.
     * The path is relative to {@link Mailbox}
     */
    sentFolder?: string;
};
