
import { MailFilterRuleFilter } from "./MailFilterRuleFilter"; 
export type MailFilterRuleFilterContains = MailFilterRuleFilter & {
    comparator?: MailFilterRuleFilterContains.Comparator;
    modifier?: MailFilterRuleFilterContains.Modifier;
    values?: Array<string>;
};
export namespace MailFilterRuleFilterContains {
    export type Modifier =  "NONE" |  "CASE_INSENSITIVE" |  "IGNORE_NONSPACING_MARK" |  "LOOSE";
    export const Modifier : {
        readonly NONE: Modifier,
        readonly CASE_INSENSITIVE: Modifier,
        readonly IGNORE_NONSPACING_MARK: Modifier,
        readonly LOOSE: Modifier
    };
    export type Comparator =  "FULLSTRING" |  "SUBSTRING" |  "PREFIX";
    export const Comparator : {
        readonly FULLSTRING: Comparator,
        readonly SUBSTRING: Comparator,
        readonly PREFIX: Comparator
    };

}
