
import { DocumentFolder } from "./DocumentFolder"; 
import { 
    ListResult
} from "@bluemind/core.foldershare.api";
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
export interface IDocumentFolder {
    /**
     * Creates a {@link DocumentFolder} item
     */
    create(uid: string, name?: string,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Removes a {@link DocumentFolder} item
     */
    delete(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    get(uid: string,  __fetchOptions?: RequestOptions): Promise<DocumentFolder>;
    /**
     * Lists all {@link DocumentFolder}
     */
    list( __fetchOptions?: RequestOptions): Promise<ListResult<DocumentFolder>>;
    /**
     * Rename a {@link DocumentFolder} item
     */
    rename(uid: string, name?: string,  __fetchOptions?: RequestOptions): Promise<void>;
}

export declare class DocumentFolderClient extends ApiEndPoint implements IDocumentFolder {
    containerUid: string;
    constructor(apiKey: string, containerUid: string, base?: string);
    create(uid: string, name?: string,  __fetchOptions?: RequestOptions): Promise<void>;
    delete(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    get(uid: string,  __fetchOptions?: RequestOptions): Promise<DocumentFolder>;
    list( __fetchOptions?: RequestOptions): Promise<ListResult<DocumentFolder>>;
    rename(uid: string, name?: string,  __fetchOptions?: RequestOptions): Promise<void>;
    getMetadata(): EndPointMetadata;
}
