import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './FlatHierarchyUidsClient.json';

export class FlatHierarchyUidsClient extends ApiEndPoint {
    version = "5.4.2696";
    constructor(apiKey, base = '') {
        super(apiKey, base + '/api/flat_hierarchy/uids');
    }
    async identifier(uid, domain,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/{domain}/_entry_hierarchy';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        __path = __path.replace('{domain}', encodeURIComponent(domain));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
