import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './PublishCalendarClient.json';

export class PublishCalendarClient extends ApiEndPoint {
    version = "5.4.2696";
    constructor(apiKey, containerUid , base = '') {
        super(apiKey, base + '/api/calendars/publish/{containerUid}');
        this.containerUid = containerUid;
        this.base = this.base.replace('{containerUid}', encodeURIComponent(containerUid));
    }
    async createUrl(mode, token,  __fetchOptions = {}) {
        let __path = this.base + '/_create/{mode}';
        __path = __path.replace('{mode}', encodeURIComponent(mode));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
        if (token != null) {
            __url.searchParams.append("token", token);
        }
		return this.__fetchContent(__url, __options);
    }
    async disableUrl(url,  __fetchOptions = {}) {
        let __path = this.base + '/_disable';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (url != null) {
            __options.body = JSON.stringify(url);
        }
		return this.__fetchVoid(__url, __options);
    }
    async generateUrl(mode,  __fetchOptions = {}) {
        let __path = this.base + '/_generate/{mode}';
        __path = __path.replace('{mode}', encodeURIComponent(mode));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getGeneratedUrls(mode,  __fetchOptions = {}) {
        let __path = this.base + '/generated/{mode}';
        __path = __path.replace('{mode}', encodeURIComponent(mode));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async publish(token,  __fetchOptions = {}) {
        let __path = this.base + '/{token}';
        __path = __path.replace('{token}', encodeURIComponent(token));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', '*/*', __fetchOptions);
        return this.__fetchBlob(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
