import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './FreebusyMgmtClient.json';

export class FreebusyMgmtClient extends ApiEndPoint {
    version = "5.4.2696";
    constructor(apiKey, containerUid , base = '') {
        super(apiKey, base + '/api/mgmt/freebusy/{containerUid}');
        this.containerUid = containerUid;
        this.base = this.base.replace('{containerUid}', encodeURIComponent(containerUid));
    }
    async add(calendar,  __fetchOptions = {}) {
        let __path = this.base + '/{calendar}';
        __path = __path.replace('{calendar}', encodeURIComponent(calendar));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
		return this.__fetchVoid(__url, __options);
    }
    async get( __fetchOptions = {}) {
        const __url = new URL(this.base, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async remove(calendar,  __fetchOptions = {}) {
        let __path = this.base + '/{calendar}';
        __path = __path.replace('{calendar}', encodeURIComponent(calendar));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('DELETE', 'application/json', __fetchOptions);
		return this.__fetchVoid(__url, __options);
    }
    async set(calendars,  __fetchOptions = {}) {
        const __url = new URL(this.base, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (calendars != null) {
            __options.body = JSON.stringify(calendars);
        }
		return this.__fetchVoid(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
