
import { CalendarDescriptor } from "./CalendarDescriptor"; 
import { 
    TaskRef
} from "@bluemind/core.task.api";
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
/**
 * Calendars management api
 */
export interface ICalendarsMgmt {
    create(uid: string, descriptor?: CalendarDescriptor,  __fetchOptions?: RequestOptions): Promise<void>;
    delete(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    getComplete(uid: string,  __fetchOptions?: RequestOptions): Promise<CalendarDescriptor>;
    /**
     * reindex a calendar
     */
    reindex(containerUid: string,  __fetchOptions?: RequestOptions): Promise<TaskRef>;
    /**
     * reindex all calendars (drop current index and recreate them)
     */
    reindexAll( __fetchOptions?: RequestOptions): Promise<TaskRef>;
    update(uid: string, descriptor?: CalendarDescriptor,  __fetchOptions?: RequestOptions): Promise<void>;
}

export declare class CalendarsMgmtClient extends ApiEndPoint implements ICalendarsMgmt {
    constructor(apiKey: string, base?: string);
    create(uid: string, descriptor?: CalendarDescriptor,  __fetchOptions?: RequestOptions): Promise<void>;
    delete(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    getComplete(uid: string,  __fetchOptions?: RequestOptions): Promise<CalendarDescriptor>;
    reindex(containerUid: string,  __fetchOptions?: RequestOptions): Promise<TaskRef>;
    reindexAll( __fetchOptions?: RequestOptions): Promise<TaskRef>;
    update(uid: string, descriptor?: CalendarDescriptor,  __fetchOptions?: RequestOptions): Promise<void>;
    getMetadata(): EndPointMetadata;
}
