import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './MailboxItemsClient.json';

export class MailboxItemsClient extends ApiEndPoint {
    version = "5.4.2696";
    constructor(apiKey, replicatedMailboxUid , base = '') {
        super(apiKey, base + '/api/mail_items/{replicatedMailboxUid}');
        this.replicatedMailboxUid = replicatedMailboxUid;
        this.base = this.base.replace('{replicatedMailboxUid}', encodeURIComponent(replicatedMailboxUid));
    }
    async addFlag(flagUpdate,  __fetchOptions = {}) {
        let __path = this.base + '/_addFlag';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
        if (flagUpdate != null) {
            __options.body = JSON.stringify(flagUpdate);
        }
		return this.__fetchContent(__url, __options);
    }
    async changeset(since,  __fetchOptions = {}) {
        let __path = this.base + '/_changeset';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
        if (since != null) {
            __url.searchParams.append("since", since);
        }
		return this.__fetchContent(__url, __options);
    }
    async changesetById(since,  __fetchOptions = {}) {
        let __path = this.base + '/_changesetById';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
        if (since != null) {
            __url.searchParams.append("since", since);
        }
		return this.__fetchContent(__url, __options);
    }
    async count(arg0,  __fetchOptions = {}) {
        let __path = this.base + '/_count';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (arg0 != null) {
            __options.body = JSON.stringify(arg0);
        }
		return this.__fetchContent(__url, __options);
    }
    async create(value,  __fetchOptions = {}) {
        const __url = new URL(this.base, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
        if (value != null) {
            __options.body = JSON.stringify(value);
        }
		return this.__fetchContent(__url, __options);
    }
    async createById(id, arg1,  __fetchOptions = {}) {
        let __path = this.base + '/id/{id}';
        __path = __path.replace('{id}', encodeURIComponent(id));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
        if (arg1 != null) {
            __options.body = JSON.stringify(arg1);
        }
		return this.__fetchContent(__url, __options);
    }
    async deleteById(id,  __fetchOptions = {}) {
        let __path = this.base + '/id/{id}';
        __path = __path.replace('{id}', encodeURIComponent(id));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('DELETE', 'application/json', __fetchOptions);
		return this.__fetchVoid(__url, __options);
    }
    async deleteFlag(flagUpdate,  __fetchOptions = {}) {
        let __path = this.base + '/_deleteFlag';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (flagUpdate != null) {
            __options.body = JSON.stringify(flagUpdate);
        }
		return this.__fetchContent(__url, __options);
    }
    async expunge( __fetchOptions = {}) {
        let __path = this.base + '/_expunge';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
		return this.__fetchVoid(__url, __options);
    }
    async fetch(imapUid, address, encoding, mime, charset, filename,  __fetchOptions = {}) {
        let __path = this.base + '/part/{imapUid}/{address}';
        __path = __path.replace('{imapUid}', encodeURIComponent(imapUid));
        __path = __path.replace('{address}', encodeURIComponent(address));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', '*/*', __fetchOptions);
        if (encoding != null) {
            __url.searchParams.append("encoding", encoding);
        }
        if (mime != null) {
            __url.searchParams.append("mime", mime);
        }
        if (charset != null) {
            __url.searchParams.append("charset", charset);
        }
        if (filename != null) {
            __url.searchParams.append("filename", filename);
        }
        return this.__fetchBlob(__url, __options);
    }
    async fetchComplete(imapUid,  __fetchOptions = {}) {
        let __path = this.base + '/eml/{imapUid}';
        __path = __path.replace('{imapUid}', encodeURIComponent(imapUid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', '*/*', __fetchOptions);
        return this.__fetchBlob(__url, __options);
    }
    async fetchCompleteByGuid(guid,  __fetchOptions = {}) {
        let __path = this.base + '/eml_by_guid/{guid}';
        __path = __path.replace('{guid}', encodeURIComponent(guid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', '*/*', __fetchOptions);
        return this.__fetchBlob(__url, __options);
    }
    async filteredChangesetById(since, arg1,  __fetchOptions = {}) {
        let __path = this.base + '/_filteredChangesetById';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (since != null) {
            __url.searchParams.append("since", since);
        }
        if (arg1 != null) {
            __options.body = JSON.stringify(arg1);
        }
		return this.__fetchContent(__url, __options);
    }
    async getCompleteById(id,  __fetchOptions = {}) {
        let __path = this.base + '/{id}/completeById';
        __path = __path.replace('{id}', encodeURIComponent(id));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getForUpdate(id,  __fetchOptions = {}) {
        let __path = this.base + '/{id}/getForUpdate';
        __path = __path.replace('{id}', encodeURIComponent(id));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getVersion( __fetchOptions = {}) {
        let __path = this.base + '/_version';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async itemChangelog(uid, arg1,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/_itemchangelog';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
        if (arg1 != null) {
            __options.body = JSON.stringify(arg1);
        }
		return this.__fetchContent(__url, __options);
    }
    async listItemIdsAfter(before,  __fetchOptions = {}) {
        let __path = this.base + '/_list_after_date';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (before != null) {
            __options.body = JSON.stringify(before);
        }
		return this.__fetchContent(__url, __options);
    }
    async multipleDeleteById(arg0, bypassDeletedItems,  __fetchOptions = {}) {
        let __path = this.base + '/_multipleDelete';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('DELETE', 'application/json', __fetchOptions);
        if (bypassDeletedItems != null) {
            __url.searchParams.append("bypassDeletedItems", bypassDeletedItems);
        }
        if (arg0 != null) {
            __options.body = JSON.stringify(arg0);
        }
		return this.__fetchVoid(__url, __options);
    }
    async multipleGetById(arg0,  __fetchOptions = {}) {
        let __path = this.base + '/_mgetById';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (arg0 != null) {
            __options.body = JSON.stringify(arg0);
        }
		return this.__fetchContent(__url, __options);
    }
    async multipleUnexpungeById(itemIds,  __fetchOptions = {}) {
        let __path = this.base + '/_multipleUnexpunge';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (itemIds != null) {
            __options.body = JSON.stringify(itemIds);
        }
		return this.__fetchContent(__url, __options);
    }
    async recentItems(deliveredOrUpdatedAfter,  __fetchOptions = {}) {
        let __path = this.base + '/_recent';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
        if (deliveredOrUpdatedAfter != null) {
            __options.body = JSON.stringify(deliveredOrUpdatedAfter);
        }
		return this.__fetchContent(__url, __options);
    }
    async removePart(partId,  __fetchOptions = {}) {
        let __path = this.base + '/{partId}/_part';
        __path = __path.replace('{partId}', encodeURIComponent(partId));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('DELETE', 'application/json', __fetchOptions);
		return this.__fetchVoid(__url, __options);
    }
    async sortedIds(arg0,  __fetchOptions = {}) {
        let __path = this.base + '/_sorted';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (arg0 != null) {
            __options.body = JSON.stringify(arg0);
        }
		return this.__fetchContent(__url, __options);
    }
    async sortedUids(arg0,  __fetchOptions = {}) {
        let __path = this.base + '/_sorteduids';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (arg0 != null) {
            __options.body = JSON.stringify(arg0);
        }
		return this.__fetchContent(__url, __options);
    }
    async unexpunge(itemId,  __fetchOptions = {}) {
        let __path = this.base + '/_unexpunge/{itemId}';
        __path = __path.replace('{itemId}', encodeURIComponent(itemId));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async unreadItems( __fetchOptions = {}) {
        let __path = this.base + '/_unread';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async updateById(id, arg1,  __fetchOptions = {}) {
        let __path = this.base + '/id/{id}';
        __path = __path.replace('{id}', encodeURIComponent(id));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (arg1 != null) {
            __options.body = JSON.stringify(arg1);
        }
		return this.__fetchContent(__url, __options);
    }
    async uploadPart(part,  __fetchOptions = {}) {
        let __path = this.base + '/_part';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
        if (part != null) {
            __options.body = part;
        }
		return this.__fetchContent(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
