import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './ItemsTransferClient.json';

export class ItemsTransferClient extends ApiEndPoint {
    version = "5.4.2696";
    constructor(apiKey, fromMailboxUid , toMailboxUid , base = '') {
        super(apiKey, base + '/api/mail_items_transfer/{fromMailboxUid}/{toMailboxUid}');
        this.fromMailboxUid = fromMailboxUid;
        this.base = this.base.replace('{fromMailboxUid}', encodeURIComponent(fromMailboxUid));
        this.toMailboxUid = toMailboxUid;
        this.base = this.base.replace('{toMailboxUid}', encodeURIComponent(toMailboxUid));
    }
    async copy(itemIds,  __fetchOptions = {}) {
        let __path = this.base + '/copy';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (itemIds != null) {
            __options.body = JSON.stringify(itemIds);
        }
		return this.__fetchContent(__url, __options);
    }
    async move(itemIds,  __fetchOptions = {}) {
        let __path = this.base + '/move';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (itemIds != null) {
            __options.body = JSON.stringify(itemIds);
        }
		return this.__fetchContent(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
