import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './AddressBooksClient.json';

export class AddressBooksClient extends ApiEndPoint {
    version = "5.4.2696";
    constructor(apiKey, base = '') {
        super(apiKey, base + '/api/addressbooks');
    }
    async findCertsByEmail(email,  __fetchOptions = {}) {
        let __path = this.base + '/_findCertsByEmail';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (email != null) {
            __url.searchParams.append("email", email);
        }
		return this.__fetchContent(__url, __options);
    }
    async findUidsByEmail(email,  __fetchOptions = {}) {
        let __path = this.base + '/_findUidsByEmail';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (email != null) {
            __options.body = JSON.stringify(email);
        }
		return this.__fetchContent(__url, __options);
    }
    async search(query,  __fetchOptions = {}) {
        let __path = this.base + '/_search';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (query != null) {
            __options.body = JSON.stringify(query);
        }
		return this.__fetchContent(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
