
import { VCardInfo } from "./VCardInfo"; 
import { VCardChanges } from "./VCardChanges"; 
import { VCardQuery } from "./VCardQuery"; 
import { VCard } from "./VCard"; 
import { 
    ContainerChangeset,
    ItemFlagFilter,
    ItemValue,
    Ack,
    SortDescriptor,
    ContainerUpdatesResult,
    Count,
    ItemChangelog,
    ItemVersion
} from "@bluemind/core.container.api";
import { 
    ListResult
} from "@bluemind/core.foldershare.api";
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
/**
 * Addressbooks APIs. BlueMind provides client and server side implementations
 * of this interface.
 */
export interface IAddressBook {
    /**
     * List all items from container
     */
    allUids( __fetchOptions?: RequestOptions): Promise<Array<string>>;
    changeset(since?: number,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<string>>;
    changesetById(since?: number,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<number>>;
    /**
     * Copy entries from one AddressBook to another one
     */
    copy(uids?: Array<string>, destContainerUid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    count(arg0?: ItemFlagFilter,  __fetchOptions?: RequestOptions): Promise<Count>;
    /**
     * Creates a new {@link VCard} entry.
     * @param uid uid of the entry
     * @param card value of the entry
     */
    create(uid: string, card?: VCard,  __fetchOptions?: RequestOptions): Promise<void>;
    createById(id: number, arg1?: VCard,  __fetchOptions?: RequestOptions): Promise<Ack>;
    /**
     * Delete vcard entry
     */
    delete(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    deleteById(id: number,  __fetchOptions?: RequestOptions): Promise<void>;
    deletePhoto(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    filteredChangesetById(since?: number, arg1?: ItemFlagFilter,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<ItemVersion>>;
    /**
     * Fetch a {@link VCard} from its unique uid
     * @returns {@link ItemValue<VCard>}
     */
    getComplete(uid: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<VCard>>;
    getCompleteById(id: number,  __fetchOptions?: RequestOptions): Promise<ItemValue<VCard>>;
    /**
     * A scaled-down (22px x 22px) version of the photo
     */
    getIcon(uid: string,  __fetchOptions?: RequestOptions): Promise<ArrayBuffer>;
    /**
     * Fetch a {@link VCardInfo} from its unique uid
     */
    getInfo(uid: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<VCardInfo>>;
    getPhoto(uid: string,  __fetchOptions?: RequestOptions): Promise<ArrayBuffer>;
    getVersion( __fetchOptions?: RequestOptions): Promise<number>;
    itemChangelog(uid: string, arg1?: number,  __fetchOptions?: RequestOptions): Promise<ItemChangelog>;
    /**
     * Move entries from one AddressBook to another one
     */
    move(uids?: Array<string>, destContainerUid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    multipleDeleteById(arg0?: Array<number>, bypassDeletedItems?: boolean,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Fetch multiple {@link VCard}s from theirs uniques uids
     * @returns {@link List<ItemValue<VCard>>}
     */
    multipleGet(uids?: Array<string>,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<VCard>>>;
    multipleGetById(arg0?: Array<number>,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<VCard>>>;
    reset( __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * ElasticSearch based vcard search
     */
    search(query?: VCardQuery,  __fetchOptions?: RequestOptions): Promise<ListResult<ItemValue<VCardInfo>>>;
    setPhoto(uid: string, photo?: ArrayBuffer,  __fetchOptions?: RequestOptions): Promise<void>;
    sortedIds(arg0?: SortDescriptor,  __fetchOptions?: RequestOptions): Promise<Array<number>>;
    sortedUids(arg0?: SortDescriptor,  __fetchOptions?: RequestOptions): Promise<Array<string>>;
    /**
     * CLIENT_WIN style
     */
    sync(since?: number, changes?: VCardChanges,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<string>>;
    /**
     * Touch a {@link VCard}.
     * @param uid the unique identifier of the vcard
     */
    touch(uid?: string,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Modifies an existing {@link VCard} entry.
     * @param uid uid of the entry
     * @param card value of the entry
     */
    update(uid: string, card?: VCard,  __fetchOptions?: RequestOptions): Promise<void>;
    updateById(id: number, arg1?: VCard,  __fetchOptions?: RequestOptions): Promise<Ack>;
    /**
     * Updates multiples entries at once (should be transactional: if one operation
     * fail, nothing is written)
     */
    updates(changes?: VCardChanges,  __fetchOptions?: RequestOptions): Promise<ContainerUpdatesResult>;
}

export declare class AddressBookClient extends ApiEndPoint implements IAddressBook {
    containerUid: string;
    constructor(apiKey: string, containerUid: string, base?: string);
    allUids( __fetchOptions?: RequestOptions): Promise<Array<string>>;
    changeset(since?: number,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<string>>;
    changesetById(since?: number,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<number>>;
    copy(uids?: Array<string>, destContainerUid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    count(arg0?: ItemFlagFilter,  __fetchOptions?: RequestOptions): Promise<Count>;
    create(uid: string, card?: VCard,  __fetchOptions?: RequestOptions): Promise<void>;
    createById(id: number, arg1?: VCard,  __fetchOptions?: RequestOptions): Promise<Ack>;
    delete(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    deleteById(id: number,  __fetchOptions?: RequestOptions): Promise<void>;
    deletePhoto(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    filteredChangesetById(since?: number, arg1?: ItemFlagFilter,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<ItemVersion>>;
    getComplete(uid: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<VCard>>;
    getCompleteById(id: number,  __fetchOptions?: RequestOptions): Promise<ItemValue<VCard>>;
    getIcon(uid: string,  __fetchOptions?: RequestOptions): Promise<ArrayBuffer>;
    getInfo(uid: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<VCardInfo>>;
    getPhoto(uid: string,  __fetchOptions?: RequestOptions): Promise<ArrayBuffer>;
    getVersion( __fetchOptions?: RequestOptions): Promise<number>;
    itemChangelog(uid: string, arg1?: number,  __fetchOptions?: RequestOptions): Promise<ItemChangelog>;
    move(uids?: Array<string>, destContainerUid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    multipleDeleteById(arg0?: Array<number>, bypassDeletedItems?: boolean,  __fetchOptions?: RequestOptions): Promise<void>;
    multipleGet(uids?: Array<string>,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<VCard>>>;
    multipleGetById(arg0?: Array<number>,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<VCard>>>;
    reset( __fetchOptions?: RequestOptions): Promise<void>;
    search(query?: VCardQuery,  __fetchOptions?: RequestOptions): Promise<ListResult<ItemValue<VCardInfo>>>;
    setPhoto(uid: string, photo?: ArrayBuffer,  __fetchOptions?: RequestOptions): Promise<void>;
    sortedIds(arg0?: SortDescriptor,  __fetchOptions?: RequestOptions): Promise<Array<number>>;
    sortedUids(arg0?: SortDescriptor,  __fetchOptions?: RequestOptions): Promise<Array<string>>;
    sync(since?: number, changes?: VCardChanges,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<string>>;
    touch(uid?: string,  __fetchOptions?: RequestOptions): Promise<void>;
    update(uid: string, card?: VCard,  __fetchOptions?: RequestOptions): Promise<void>;
    updateById(id: number, arg1?: VCard,  __fetchOptions?: RequestOptions): Promise<Ack>;
    updates(changes?: VCardChanges,  __fetchOptions?: RequestOptions): Promise<ContainerUpdatesResult>;
    getMetadata(): EndPointMetadata;
}
