import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './VideoConferencingSaasClient.json';

export class VideoConferencingSaasClient extends ApiEndPoint {
    version = "5.4.2696";
    constructor(apiKey, base = '') {
        super(apiKey, base + '/api/videoconferencing/saas');
    }
    async create(room,  __fetchOptions = {}) {
        let __path = this.base + '/createRoom';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (room != null) {
            __options.body = JSON.stringify(room);
        }
		return this.__fetchContent(__url, __options);
    }
    async get(roomName,  __fetchOptions = {}) {
        let __path = this.base + '/getRoom/{roomName}';
        __path = __path.replace('{roomName}', encodeURIComponent(roomName));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async token(roomName,  __fetchOptions = {}) {
        let __path = this.base + '/createToken/{roomName}';
        __path = __path.replace('{roomName}', encodeURIComponent(roomName));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async updateTitle(roomName, title,  __fetchOptions = {}) {
        let __path = this.base + '/updateTitle/{roomName}';
        __path = __path.replace('{roomName}', encodeURIComponent(roomName));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (title != null) {
            __options.body = JSON.stringify(title);
        }
		return this.__fetchVoid(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
