import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './UserSettingsClient.json';

export class UserSettingsClient extends ApiEndPoint {
    version = "5.4.2696";
    constructor(apiKey, containerUid , base = '') {
        super(apiKey, base + '/api/users/{containerUid}');
        this.containerUid = containerUid;
        this.base = this.base.replace('{containerUid}', encodeURIComponent(containerUid));
    }
    async get(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/_settings';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getOne(uid, name,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/_setting/{name}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        __path = __path.replace('{name}', encodeURIComponent(name));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async set(uid, settings,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/_settings';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (settings != null) {
            __options.body = JSON.stringify(settings);
        }
		return this.__fetchVoid(__url, __options);
    }
    async setOne(uid, name, value,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/_setting/{name}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        __path = __path.replace('{name}', encodeURIComponent(name));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (value != null) {
            __options.body = JSON.stringify(value);
        }
		return this.__fetchVoid(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
