export type LogLevel =  "PROGRESS" |  "INFO" |  "WARNING" |  "ERROR";
export const LogLevel : {
    /**
     * Progress report percentage
     */
    readonly PROGRESS: LogLevel,
    /**
     * Logs from this severity can be ignored. They are just here to inform of
     * what the job is doing
     */
    readonly INFO: LogLevel,
    /**
     * Something un-expected happended.
     */
    readonly WARNING: LogLevel,
    /**
     * Something we could not recover from happened.
     */
    readonly ERROR: LogLevel
};
