import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './JobClient.json';

export class JobClient extends ApiEndPoint {
    version = "5.4.2696";
    constructor(apiKey, base = '') {
        super(apiKey, base + '/api/scheduledjobs');
    }
    async cancel(jobId, domainName,  __fetchOptions = {}) {
        let __path = this.base + '/_cancel/{jobId}';
        __path = __path.replace('{jobId}', encodeURIComponent(jobId));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('DELETE', 'application/json', __fetchOptions);
        if (domainName != null) {
            __url.searchParams.append("domainName", domainName);
        }
		return this.__fetchVoid(__url, __options);
    }
    async deleteExecution(jobExecutionId,  __fetchOptions = {}) {
        let __path = this.base + '/_deleteExecution';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('DELETE', 'application/json', __fetchOptions);
        if (jobExecutionId != null) {
            __url.searchParams.append("jobExecutionId", jobExecutionId);
        }
		return this.__fetchVoid(__url, __options);
    }
    async deleteExecutions(executions,  __fetchOptions = {}) {
        let __path = this.base + '/_deleteExecutions';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('DELETE', 'application/json', __fetchOptions);
        if (executions != null) {
            __options.body = JSON.stringify(executions);
        }
		return this.__fetchVoid(__url, __options);
    }
    async getJobFromId(jobId,  __fetchOptions = {}) {
        let __path = this.base + '/_job/{jobId}';
        __path = __path.replace('{jobId}', encodeURIComponent(jobId));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getLogs(jobExecution, offset,  __fetchOptions = {}) {
        let __path = this.base + '/_logs';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (offset != null) {
            __url.searchParams.append("offset", offset);
        }
        if (jobExecution != null) {
            __options.body = JSON.stringify(jobExecution);
        }
		return this.__fetchContent(__url, __options);
    }
    async searchExecution(query,  __fetchOptions = {}) {
        let __path = this.base + '/_searchExecution';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (query != null) {
            __options.body = JSON.stringify(query);
        }
		return this.__fetchContent(__url, __options);
    }
    async searchJob(query,  __fetchOptions = {}) {
        let __path = this.base + '/_searchJob';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (query != null) {
            __options.body = JSON.stringify(query);
        }
		return this.__fetchContent(__url, __options);
    }
    async start(jobId, domainName,  __fetchOptions = {}) {
        let __path = this.base + '/_start/{jobId}';
        __path = __path.replace('{jobId}', encodeURIComponent(jobId));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (domainName != null) {
            __url.searchParams.append("domainName", domainName);
        }
		return this.__fetchVoid(__url, __options);
    }
    async update(job,  __fetchOptions = {}) {
        let __path = this.base + '/_updateJob';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (job != null) {
            __options.body = JSON.stringify(job);
        }
		return this.__fetchVoid(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
