
import { LogEntry } from "./LogEntry"; 
import { Job } from "./Job"; 
import { JobQuery } from "./JobQuery"; 
import { JobExecution } from "./JobExecution"; 
import { JobExecutionQuery } from "./JobExecutionQuery"; 
import { 
    ListResult
} from "@bluemind/core.foldershare.api";
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
export interface IJob {
    /**
     * Cancel running job by its ID
     */
    cancel(jobId: string, domainName?: string,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Removes one execution. Removes nothing if your token has no right on this
     * execution (global job, different domain, etc)
     */
    deleteExecution(jobExecutionId?: number,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Removes multiple executions.
     */
    deleteExecutions(executions?: Array<number>,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Get job using its id
     */
    getJobFromId(jobId: string,  __fetchOptions?: RequestOptions): Promise<Job>;
    /**
     * Return the logs of a job. The offset indicates how much logs you already
     * fetched in a previous call.
     */
    getLogs(jobExecution?: JobExecution, offset?: number,  __fetchOptions?: RequestOptions): Promise<Array<LogEntry>>;
    /**
     * Fetch recorded job executions. Pagination is supported. global & non-global
     * admins will get different results.
     * @returns list of job executions, sorted by start execution date in descending
     *         order
     */
    searchExecution(query?: JobExecutionQuery,  __fetchOptions?: RequestOptions): Promise<ListResult<JobExecution>>;
    /**
     * List jobs deployed. global & non-global admins will get different results.
     */
    searchJob(query?: JobQuery,  __fetchOptions?: RequestOptions): Promise<ListResult<Job>>;
    /**
     * Get active job using its ID
     * 
     * force-start a job. Execution is recorded when the job finishes.
     */
    start(jobId: string, domainName?: string,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Update job planification {@link JobPlanification}
     */
    update(job?: Job,  __fetchOptions?: RequestOptions): Promise<void>;
}

export declare class JobClient extends ApiEndPoint implements IJob {
    constructor(apiKey: string, base?: string);
    cancel(jobId: string, domainName?: string,  __fetchOptions?: RequestOptions): Promise<void>;
    deleteExecution(jobExecutionId?: number,  __fetchOptions?: RequestOptions): Promise<void>;
    deleteExecutions(executions?: Array<number>,  __fetchOptions?: RequestOptions): Promise<void>;
    getJobFromId(jobId: string,  __fetchOptions?: RequestOptions): Promise<Job>;
    getLogs(jobExecution?: JobExecution, offset?: number,  __fetchOptions?: RequestOptions): Promise<Array<LogEntry>>;
    searchExecution(query?: JobExecutionQuery,  __fetchOptions?: RequestOptions): Promise<ListResult<JobExecution>>;
    searchJob(query?: JobQuery,  __fetchOptions?: RequestOptions): Promise<ListResult<Job>>;
    start(jobId: string, domainName?: string,  __fetchOptions?: RequestOptions): Promise<void>;
    update(job?: Job,  __fetchOptions?: RequestOptions): Promise<void>;
    getMetadata(): EndPointMetadata;
}
