import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './RolesClient.json';

export class RolesClient extends ApiEndPoint {
    version = "5.4.2696";
    constructor(apiKey, base = '') {
        super(apiKey, base + '/api/roles');
    }
    async getRoles( __fetchOptions = {}) {
        let __path = this.base + '/descriptors';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getRolesCategories( __fetchOptions = {}) {
        let __path = this.base + '/categories';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
