import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './MailTipClient.json';

export class MailTipClient extends ApiEndPoint {
    version = "5.4.2696";
    constructor(apiKey, domainUid , base = '') {
        super(apiKey, base + '/api/mailtip/{domainUid}');
        this.domainUid = domainUid;
        this.base = this.base.replace('{domainUid}', encodeURIComponent(domainUid));
    }
    async getMailTips(mailtipContext,  __fetchOptions = {}) {
        const __url = new URL(this.base, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (mailtipContext != null) {
            __options.body = JSON.stringify(mailtipContext);
        }
		return this.__fetchContent(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
