
export type Recipient = {
    email?: string;
    name?: string;
    addressType?: Recipient.AddressType;
    recipientType?: Recipient.RecipientType;
};
export namespace Recipient {
    export type RecipientType =  "TO" |  "CC" |  "BCC";
    export const RecipientType : {
        readonly TO: RecipientType,
        readonly CC: RecipientType,
        readonly BCC: RecipientType
    };
    export type AddressType =  "SMTP" |  "DIR_ENTRY";
    export const AddressType : {
        readonly SMTP: AddressType,
        readonly DIR_ENTRY: AddressType
    };

}
