import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './OrgUnitsClient.json';

export class OrgUnitsClient extends ApiEndPoint {
    version = "5.4.2696";
    constructor(apiKey, domain , base = '') {
        super(apiKey, base + '/api/directory/_ou/{domain}');
        this.domain = domain;
        this.base = this.base.replace('{domain}', encodeURIComponent(domain));
    }
    async create(uid, value,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
        if (value != null) {
            __options.body = JSON.stringify(value);
        }
		return this.__fetchVoid(__url, __options);
    }
    async delete(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('DELETE', 'application/json', __fetchOptions);
		return this.__fetchVoid(__url, __options);
    }
    async getAdministratorRoles(uid, dirUid, groups,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/{dirUid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        __path = __path.replace('{dirUid}', encodeURIComponent(dirUid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (groups != null) {
            __options.body = JSON.stringify(groups);
        }
		return this.__fetchContent(__url, __options);
    }
    async getAdministrators(uid, hierarchical,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/_administrators';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
        if (hierarchical != null) {
            __url.searchParams.append("hierarchical", hierarchical);
        }
		return this.__fetchContent(__url, __options);
    }
    async getChildren(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/_children';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getComplete(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/complete';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getPath(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/path';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async listByAdministrator(administrator, groups,  __fetchOptions = {}) {
        let __path = this.base + '/_byAdmin';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (administrator != null) {
            __url.searchParams.append("administrator", administrator);
        }
        if (groups != null) {
            __options.body = JSON.stringify(groups);
        }
		return this.__fetchContent(__url, __options);
    }
    async removeAdministrator(administrator,  __fetchOptions = {}) {
        let __path = this.base + '/_deleteadmin';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('DELETE', 'application/json', __fetchOptions);
        if (administrator != null) {
            __url.searchParams.append("administrator", administrator);
        }
		return this.__fetchVoid(__url, __options);
    }
    async search(query,  __fetchOptions = {}) {
        let __path = this.base + '/_search';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (query != null) {
            __options.body = JSON.stringify(query);
        }
		return this.__fetchContent(__url, __options);
    }
    async setAdministratorRoles(uid, dirUid, roles,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/{dirUid}/_set';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        __path = __path.replace('{dirUid}', encodeURIComponent(dirUid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (roles != null) {
            __options.body = JSON.stringify(roles);
        }
		return this.__fetchVoid(__url, __options);
    }
    async update(uid, value,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (value != null) {
            __options.body = JSON.stringify(value);
        }
		return this.__fetchVoid(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
