import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
/**
 * To unify the management of changelogs, ACLs, client synchronization,
 * permissions and sharing, Bluemind stores all elements in a generic structure
 * called a container. All containers are identified by a unique ID. Some
 * containers are named (UID) in a specific manner to express a certain meaning.
 * 
 * 
 * Returns specific owner subscription container UIDs.
 */
export interface IOwnerSubscriptionUids {
    /**
     * Returns the owner subscription container UID
     * @param domain id domain
     * @returns owner subscription container uid
     */
    identifier(uid: string, domain: string,  __fetchOptions?: RequestOptions): Promise<string>;
}

export declare class OwnerSubscriptionUidsClient extends ApiEndPoint implements IOwnerSubscriptionUids {
    constructor(apiKey: string, base?: string);
    identifier(uid: string, domain: string,  __fetchOptions?: RequestOptions): Promise<string>;
    getMetadata(): EndPointMetadata;
}
