
/**
 * The up-to-date status of a container.
 */
export type ContainerSyncStatus = {
    /**
     * Tokens needed for the synchronization.
     */
    syncTokens: Record<string, string>;
    /**
     * When the next synchronization should be done in milliseconds.
     */
    nextSync?: number;
    /**
     * When the last synchronization has been done.
     */
    lastSync?: number;
    /**
     * The {@link Status} of the synchronization.
     */
    syncStatus?: ContainerSyncStatus.Status;
    /**
     * Container specific status informations.
     */
    syncStatusInfo?: string;
};
export namespace ContainerSyncStatus {
    /**
     * Possible statuses.
     */
    export type Status =  "SUCCESS" |  "ERROR";
    export const Status : {
        readonly SUCCESS: Status,
        readonly ERROR: Status
    };

}
