import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './OutboxClient.json';

export class OutboxClient extends ApiEndPoint {
    version = "5.4.2696";
    constructor(apiKey, domainUid , mailboxUid , base = '') {
        super(apiKey, base + '/api/outbox/{domainUid}/{mailboxUid}');
        this.domainUid = domainUid;
        this.base = this.base.replace('{domainUid}', encodeURIComponent(domainUid));
        this.mailboxUid = mailboxUid;
        this.base = this.base.replace('{mailboxUid}', encodeURIComponent(mailboxUid));
    }
    async flush( __fetchOptions = {}) {
        let __path = this.base + '/flush';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
