
import { DispositionType } from "./DispositionType"; 
export type MessageBody = {
    guid?: string;
    subject?: string;
    /**
     * True with real attachments, false if all attachments are inline
     */
    smartAttach?: boolean;
    date?: number;
    created?: number;
    size?: number;
    headers?: Array<MessageBody.Header>;
    recipients?: Array<MessageBody.Recipient>;
    messageId?: string;
    references?: Array<string>;
    structure?: MessageBody.Part;
    preview?: string;
    bodyVersion?: number;
};
export namespace MessageBody {
    export type Header = {
        name?: string;
        values?: Array<string>;
    };
    export type Recipient = {
        kind?: MessageBody.RecipientKind;
        address?: string;
        dn?: string;
    };
    export type RecipientKind =  "Originator" |  "Sender" |  "Primary" |  "CarbonCopy" |  "BlindCarbonCopy";
    export const RecipientKind : {
        readonly Originator: RecipientKind,
        readonly Sender: RecipientKind,
        readonly Primary: RecipientKind,
        readonly CarbonCopy: RecipientKind,
        readonly BlindCarbonCopy: RecipientKind
    };
    export type Part = {
        mime?: string;
        mimeParameters?: Record<string, string>;
        address?: string;
        encoding?: string;
        charset?: string;
        fileName?: string;
        headers?: Array<MessageBody.Header>;
        contentId?: string;
        hash?: string;
        /**
         * Parts with a multipart/... mime type have children.
         */
        children?: Array<MessageBody.Part>;
        /**
         * Only for leaf parts
         */
        size?: number;
        dispositionType?: DispositionType;
    };

}
