import { 
    ItemIdentifier
} from "@bluemind/core.container.api";
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
/**
 * Transfer items between mailboxes that might live on separate backends
 */
export interface IItemsTransfer {
    copy(itemIds?: Array<number>,  __fetchOptions?: RequestOptions): Promise<Array<ItemIdentifier>>;
    move(itemIds?: Array<number>,  __fetchOptions?: RequestOptions): Promise<Array<ItemIdentifier>>;
}

export declare class ItemsTransferClient extends ApiEndPoint implements IItemsTransfer {
    fromMailboxUid: string;
    toMailboxUid: string;
    constructor(apiKey: string, fromMailboxUid: string, toMailboxUid: string, base?: string);
    copy(itemIds?: Array<number>,  __fetchOptions?: RequestOptions): Promise<Array<ItemIdentifier>>;
    move(itemIds?: Array<number>,  __fetchOptions?: RequestOptions): Promise<Array<ItemIdentifier>>;
    getMetadata(): EndPointMetadata;
}
