import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './APIKeysClient.json';

export class APIKeysClient extends ApiEndPoint {
    version = "5.4.2696";
    constructor(apiKey, base = '') {
        super(apiKey, base + '/api/auth/keys');
    }
    async create(displayName,  __fetchOptions = {}) {
        const __url = new URL(this.base, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
        if (displayName != null) {
            __url.searchParams.append("displayName", displayName);
        }
		return this.__fetchContent(__url, __options);
    }
    async delete(sid,  __fetchOptions = {}) {
        let __path = this.base + '/{sid}';
        __path = __path.replace('{sid}', encodeURIComponent(sid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('DELETE', 'application/json', __fetchOptions);
		return this.__fetchVoid(__url, __options);
    }
    async get(sid,  __fetchOptions = {}) {
        let __path = this.base + '/{sid}';
        __path = __path.replace('{sid}', encodeURIComponent(sid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async list( __fetchOptions = {}) {
        const __url = new URL(this.base, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async listAll( __fetchOptions = {}) {
        let __path = this.base + '/_all';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async store(key, displayName,  __fetchOptions = {}) {
        let __path = this.base + '/{key}';
        __path = __path.replace('{key}', encodeURIComponent(key));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
        if (displayName != null) {
            __url.searchParams.append("displayName", displayName);
        }
		return this.__fetchContent(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
