import { ProgressMonitor } from "./ProgressMonitor";
import * as xhr from "./xhr";

export class ApiEndPoint {
    constructor(apiKey, base) {
        this.apiKey = apiKey;
        this.base = base;
    }
    __fetchContent(url, options) {
        return this.__execute(url, options, (response) => (response.status === 204 ? null : response.json()));
    }
    __fetchBlob(url, options) {
        return this.__execute(url, options, (response) => response.blob());
    }
    __fetchVoid(url, options) {
        return this.__execute(url, options, () => Promise.resolve());
    }
    async __execute(url, options, getContentCallback) {
        const response = await this.__fetch(url, options);
        if (response.ok) {
            try {
                return getContentCallback(response);
            } catch (error) {
                throw new Error(response.status + ":" + response.statusText);
            }
        } else {
            const content = await response.json();
            if (content) {
                throw new Error(content.message, { cause: content });
            } else {
                throw new Error(response.status + ":" + response.statusText);
            }
        }
    }
    __getRequestInit(method, mime, options) {
        const headers = {
            "X-BM-ClientVersion": this.version,
            Accept: mime,
            ...options?.headers,
        };
        if (this.apiKey) {
            headers["X-BM-ApiKey"] = this.apiKey;
        }
        return {
            ...options,
            method,
            headers,
        };
    }
    __fetch(url, options) {
        if (options.monitor?.addEventListener) {
            return xhr.fetch(url, options);
        } else {
            return fetch(url, options);
        }
    }
}
