import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './UserAnnouncementsClient.json';

export class UserAnnouncementsClient extends ApiEndPoint {
    version = "5.4.2696";
    constructor(apiKey, userUid , base = '') {
        super(apiKey, base + '/api/userannouncements/{userUid}');
        this.userUid = userUid;
        this.base = this.base.replace('{userUid}', encodeURIComponent(userUid));
    }
    async get( __fetchOptions = {}) {
        const __url = new URL(this.base, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
