
import { VCard } from "./VCard"; 
export type VCardChanges = {
    /**
     * updated items
     */
    add?: Array<VCardChanges.ItemAdd>;
    /**
     * modified items
     */
    modify?: Array<VCardChanges.ItemModify>;
    /**
     * deleted items
     */
    delete?: Array<VCardChanges.ItemDelete>;
};
export namespace VCardChanges {
    export type ItemAdd = {
        uid?: string;
        value?: VCard;
        /**
         * <ul>
         * <li>null => do nothing
         * <li>byte[0] => delete photo
         * <li>else upload photo
         */
        photo?: ArrayBuffer;
    };
    export type ItemModify = {
        uid?: string;
        value?: VCard;
        /**
         * <ul>
         * <li>null => do nothing
         * <li>byte[0] => delete photo
         * <li>else upload photo
         */
        photo?: ArrayBuffer;
    };
    export type ItemDelete = {
        uid?: string;
    };

}
