/*
 * Decompiled with CFR 0.152.
 */
package net.bluemind.webmodules.login.verticle;

import io.vertx.core.AbstractVerticle;
import net.bluemind.hornetq.client.Consumer;
import net.bluemind.hornetq.client.MQ;
import net.bluemind.webmodules.login.services.ReadDomainsSettingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginHandlerVerticle
extends AbstractVerticle {
    private static final Logger logger = LoggerFactory.getLogger(LoginHandlerVerticle.class);
    private static final String BM_EXTERNAL_URL_FILEPATH = "/etc/bm/domains-settings";
    public static boolean suspended = false;

    public void start() {
        this.domainSettingsEvent(BM_EXTERNAL_URL_FILEPATH);
        MQ.init(() -> {
            Consumer consumer = MQ.registerConsumer((String)"end.domain.settings.file.updated", oOPMessage -> {
                String string = oOPMessage.toJson().getString("filepath");
                this.domainSettingsEvent(string);
            });
        });
    }

    private void domainSettingsEvent(String string) {
        if (suspended) {
            logger.warn("LoginHandlerVerticle does not read domains settings file");
            return;
        }
        try {
            ReadDomainsSettingService readDomainsSettingService = ReadDomainsSettingService.build(string);
            readDomainsSettingService.sync();
            logger.info("Update HPS with domains-settings file {}", (Object)string);
        }
        catch (Exception exception) {
            logger.error("Error during read domains settings file", (Throwable)exception);
        }
    }
}

