/*
 * Decompiled with CFR 0.152.
 */
package net.bluemind.webmodules.login.hps;

import com.google.common.base.Strings;
import com.netflix.spectator.api.Registry;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.api.fault.ErrorCode;
import net.bluemind.core.api.fault.ServerFault;
import net.bluemind.metrics.registry.IdFactory;
import net.bluemind.metrics.registry.MetricsRegistry;
import net.bluemind.proxy.http.IAuthProvider;
import net.bluemind.proxy.http.auth.api.AuthRequirements;
import net.bluemind.proxy.http.auth.api.IAuthEnforcer;
import net.bluemind.proxy.http.auth.api.SecurityConfig;
import net.bluemind.webmodule.server.WebModuleRootHandler;
import net.bluemind.webmodules.login.CSRFTokenManager;
import net.bluemind.webmodules.login.UpdatePasswordHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebModuleProtocol
implements IAuthEnforcer.IAuthProtocol {
    private static final Logger logger = LoggerFactory.getLogger(WebModuleProtocol.class);
    private static final Registry registry = MetricsRegistry.get();
    private static final String csrfDisabledFile = "/etc/bm/csrf.disabled";
    private static final boolean csrfDisabled = new File("/etc/bm/csrf.disabled").exists();
    private final IdFactory idFactory = new IdFactory(registry, WebModuleProtocol.class);
    private WebModuleRootHandler rootHandler;

    public WebModuleProtocol(Vertx vertx) {
        this.rootHandler = WebModuleRootHandler.build((Vertx)vertx);
        if (csrfDisabled) {
            logger.info("CSRF disabled because file {} exists", (Object)csrfDisabledFile);
        }
    }

    public void proceed(AuthRequirements authRequirements, IAuthEnforcer.ISessionStore iSessionStore, IAuthProvider iAuthProvider, HttpServerRequest httpServerRequest) {
        String string = httpServerRequest.uri();
        if (logger.isDebugEnabled()) {
            logger.debug("proceed {}...", (Object)string);
        }
        if (this.managedUpdatePasswordUrls(authRequirements, iSessionStore, iAuthProvider, httpServerRequest)) {
            return;
        }
        if (this.managedLoginUrls(authRequirements, iSessionStore, iAuthProvider, httpServerRequest)) {
            return;
        }
        if (string.startsWith("/login")) {
            this.rootHandler.handle(httpServerRequest);
        } else {
            httpServerRequest.response().setStatusCode(302);
            try {
                httpServerRequest.response().headers().add("Location", "/login/index.html?askedUri=" + URLEncoder.encode(httpServerRequest.uri(), "utf-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                httpServerRequest.response().headers().add("Location", "/login/index.html");
            }
            httpServerRequest.response().end();
        }
    }

    private boolean managedLoginUrls(AuthRequirements authRequirements, IAuthEnforcer.ISessionStore iSessionStore, IAuthProvider iAuthProvider, HttpServerRequest httpServerRequest) {
        if (!authRequirements.authNeeded && authRequirements.sessionId != null && (httpServerRequest.path().equals("/login/index.html") || httpServerRequest.path().equals("/login/native"))) {
            this.redirectAlreadyAuthenticated(httpServerRequest);
            return true;
        }
        if (httpServerRequest.method() == HttpMethod.POST && (httpServerRequest.uri().endsWith("index.html") || httpServerRequest.uri().endsWith("native"))) {
            httpServerRequest.setExpectMultipart(true);
            httpServerRequest.endHandler(void_ -> this.loginFormSubmitted(iAuthProvider, iSessionStore, httpServerRequest, authRequirements.protocol));
            return true;
        }
        return false;
    }

    private void redirectAlreadyAuthenticated(HttpServerRequest httpServerRequest) {
        String string = this.checkAskedUri(httpServerRequest.params());
        HttpServerResponse httpServerResponse = httpServerRequest.response();
        httpServerResponse.headers().add("Location", string);
        httpServerResponse.setStatusCode(302);
        httpServerResponse.end();
    }

    private void loginFormSubmitted(final IAuthProvider iAuthProvider, final IAuthEnforcer.ISessionStore iSessionStore, final HttpServerRequest httpServerRequest, final IAuthEnforcer.IAuthProtocol iAuthProtocol) {
        MultiMap multiMap = httpServerRequest.formAttributes();
        final String string = this.checkAskedUri(multiMap);
        String string2 = multiMap.get("login");
        String string3 = multiMap.get("password");
        if (string2 == null || string2.isEmpty()) {
            this.handleAuthFailure(httpServerRequest, (Throwable)new ServerFault("invalid login", ErrorCode.INVALID_PARAMETER));
            return;
        }
        if (!csrfDisabled && !CSRFTokenManager.INSTANCE.checkToken(httpServerRequest, multiMap.get("csrfToken"))) {
            this.handleAuthFailure(httpServerRequest, (Throwable)new ServerFault("Authentication for " + string2 + " fail: invalid CSRF token", ErrorCode.INVALID_PARAMETER));
            return;
        }
        final boolean bl = "priv".equals(multiMap.get("priv"));
        if (multiMap.get("domain") != null && !string2.contains("@")) {
            string2 = String.valueOf(string2) + "@" + multiMap.get("domain");
        }
        logger.info("[{}] l: '{}', p: '{}' for {}", new Object[]{iAuthProvider, string2, "****", string});
        final HttpServerResponse httpServerResponse = httpServerRequest.response();
        ArrayList<String> arrayList = new ArrayList<String>(httpServerRequest.headers().getAll("X-Forwarded-For"));
        arrayList.add(httpServerRequest.remoteAddress().host());
        iAuthProvider.sessionId(string2, string3, bl, arrayList, (AsyncHandler)new AsyncHandler<String>(){

            public void success(String string3) {
                registry.counter(WebModuleProtocol.this.idFactory.name("authCount", new String[]{"status", "success"})).increment();
                String string2 = iSessionStore.newSession(string3, iAuthProtocol);
                boolean bl2 = iAuthProvider.isPasswordExpired(string3);
                logger.info("Got sid: {}, proxySid: {}, updatePasswordNeeded: {}", new Object[]{string3, string2, bl2});
                httpServerResponse.headers().add("Location", bl2 ? "/login/updatepassword.html" : string);
                httpServerResponse.setStatusCode(302);
                DefaultCookie defaultCookie = new DefaultCookie("BMHPS", string2);
                defaultCookie.setPath("/");
                defaultCookie.setHttpOnly(true);
                if (SecurityConfig.secureCookies) {
                    defaultCookie.setSecure(true);
                }
                DefaultCookie defaultCookie2 = new DefaultCookie("BMPRIVACY", Boolean.toString(bl));
                defaultCookie2.setPath("/");
                if (SecurityConfig.secureCookies) {
                    defaultCookie2.setSecure(true);
                }
                httpServerResponse.headers().add("Set-Cookie", ServerCookieEncoder.LAX.encode((Cookie)defaultCookie));
                httpServerResponse.headers().add("Set-Cookie", ServerCookieEncoder.LAX.encode((Cookie)defaultCookie2));
                WebModuleProtocol.this.cleanupWebmailCookies(httpServerResponse);
                httpServerResponse.end();
            }

            public void failure(Throwable throwable) {
                registry.counter(WebModuleProtocol.this.idFactory.name("authCount", new String[]{"status", "failure"})).increment();
                WebModuleProtocol.this.handleAuthFailure(httpServerRequest, throwable);
            }
        });
    }

    private void cleanupWebmailCookies(HttpServerResponse httpServerResponse) {
        DefaultCookie defaultCookie = new DefaultCookie("roundcube_sessauth", "del");
        defaultCookie.setPath("/webmail");
        defaultCookie.setSecure(true);
        defaultCookie.setMaxAge(0L);
        defaultCookie.setHttpOnly(true);
        httpServerResponse.headers().add("Set-Cookie", ServerCookieEncoder.LAX.encode((Cookie)defaultCookie));
        defaultCookie = new DefaultCookie("roundcube_sessauth", "del");
        defaultCookie.setPath("/");
        defaultCookie.setSecure(true);
        defaultCookie.setMaxAge(0L);
        defaultCookie.setHttpOnly(true);
        httpServerResponse.headers().add("Set-Cookie", ServerCookieEncoder.LAX.encode((Cookie)defaultCookie));
        defaultCookie = new DefaultCookie("roundcube_sessid", "del");
        defaultCookie.setPath("/");
        defaultCookie.setSecure(true);
        defaultCookie.setMaxAge(0L);
        defaultCookie.setHttpOnly(true);
        httpServerResponse.headers().add("Set-Cookie", ServerCookieEncoder.LAX.encode((Cookie)defaultCookie));
        defaultCookie = new DefaultCookie("roundcube_sessid", "del");
        defaultCookie.setPath("/webmail");
        defaultCookie.setSecure(true);
        defaultCookie.setMaxAge(0L);
        defaultCookie.setHttpOnly(true);
        httpServerResponse.headers().add("Set-Cookie", ServerCookieEncoder.LAX.encode((Cookie)defaultCookie));
    }

    protected void handleAuthFailure(HttpServerRequest httpServerRequest, Throwable throwable) {
        Object object;
        MultiMap multiMap = httpServerRequest.formAttributes();
        String string = this.checkAskedUri(multiMap);
        int n = 10;
        if (throwable instanceof ServerFault) {
            object = (ServerFault)throwable;
            if (object.getCode() == ErrorCode.INVALID_PARAMETER) {
                n = 1;
            } else if (object.getCode() == ErrorCode.INVALID_PASSWORD) {
                n = 2;
            }
        }
        if (n == 2) {
            logger.warn("Invalid password ({}), display login page.", (Object)throwable.getMessage());
        } else {
            logger.warn("Auth failure ({}), display login page.", (Object)throwable.getMessage(), (Object)throwable);
        }
        object = "?authErrorCode=" + n;
        if (string != null) {
            try {
                new URI(string);
                object = String.valueOf(object) + "&askedUri=" + URLEncoder.encode(string, StandardCharsets.UTF_8.toString());
            }
            catch (UnsupportedEncodingException | URISyntaxException exception) {
                logger.warn("asked uri is not a valid uri : {} ", (Object)string, (Object)exception);
            }
        }
        HttpServerResponse httpServerResponse = httpServerRequest.response();
        try {
            String string2 = URLEncoder.encode(multiMap.get("login"), StandardCharsets.UTF_8.toString());
            object = String.valueOf(object) + "&userLogin=" + string2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            logger.error("unsupported encoding", (Throwable)unsupportedEncodingException);
            httpServerResponse.setStatusCode(500);
            httpServerResponse.end();
            return;
        }
        boolean bl = "priv".equals(multiMap.get("priv"));
        DefaultCookie defaultCookie = new DefaultCookie("BMPRIVACY", Boolean.toString(bl));
        defaultCookie.setPath("/");
        if (SecurityConfig.secureCookies) {
            defaultCookie.setSecure(true);
        }
        httpServerResponse.headers().add("Set-Cookie", ServerCookieEncoder.LAX.encode((Cookie)defaultCookie));
        httpServerResponse.headers().add("Location", String.format("%s%s", httpServerRequest.path(), object));
        httpServerResponse.setStatusCode(302);
        httpServerResponse.end();
    }

    public void logout(HttpServerRequest httpServerRequest) {
        HttpServerResponse httpServerResponse = httpServerRequest.response();
        httpServerResponse.headers().add("Location", "/");
        httpServerResponse.setStatusCode(302);
        httpServerResponse.end();
    }

    private boolean managedUpdatePasswordUrls(AuthRequirements authRequirements, IAuthEnforcer.ISessionStore iSessionStore, IAuthProvider iAuthProvider, HttpServerRequest httpServerRequest) {
        if ((authRequirements.authNeeded || authRequirements.sessionId == null) && httpServerRequest.path().equals("/login/updatepassword.html")) {
            httpServerRequest.response().headers().add("Location", "/");
            httpServerRequest.response().setStatusCode(302);
            httpServerRequest.response().end();
            return true;
        }
        if (!authRequirements.authNeeded && authRequirements.sessionId != null && iAuthProvider.isPasswordExpired(authRequirements.sessionId) && !httpServerRequest.path().startsWith("/login/")) {
            httpServerRequest.response().headers().add("Location", "/login/updatepassword.html");
            httpServerRequest.response().setStatusCode(302);
            httpServerRequest.response().end();
            return true;
        }
        if (!authRequirements.authNeeded && authRequirements.sessionId != null && !iAuthProvider.isPasswordExpired(authRequirements.sessionId) && httpServerRequest.path().equals("/login/updatepassword.html")) {
            httpServerRequest.response().headers().add("Location", "/");
            httpServerRequest.response().setStatusCode(302);
            httpServerRequest.response().end();
            return true;
        }
        if (httpServerRequest.method() == HttpMethod.POST && httpServerRequest.uri().endsWith("/updatepassword.html")) {
            httpServerRequest.setExpectMultipart(true);
            httpServerRequest.endHandler(void_ -> this.updatePasswordFormSubmitted(iAuthProvider, iSessionStore, httpServerRequest, authRequirements));
            return true;
        }
        return false;
    }

    private String checkAskedUri(MultiMap multiMap) {
        String string = multiMap.get("askedUri") != null ? multiMap.get("askedUri") : "/";
        try {
            new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            logger.warn("asked uri is not un uri : {} ", (Object)string, (Object)uRISyntaxException);
            string = "/";
        }
        return string;
    }

    private void updatePasswordFormSubmitted(IAuthProvider iAuthProvider, IAuthEnforcer.ISessionStore iSessionStore, HttpServerRequest httpServerRequest, AuthRequirements authRequirements) {
        MultiMap multiMap = httpServerRequest.formAttributes();
        String string = this.checkAskedUri(multiMap);
        if (!CSRFTokenManager.INSTANCE.checkToken(httpServerRequest, multiMap.get("csrfToken"))) {
            httpServerRequest.response().headers().add("Location", "/bluemind_sso_logout");
            httpServerRequest.response().setStatusCode(302);
            httpServerRequest.response().end();
            return;
        }
        String string2 = multiMap.get("password");
        String string3 = multiMap.get("new-password");
        String string4 = multiMap.get("confirm-password");
        if (Strings.isNullOrEmpty((String)string2) || Strings.isNullOrEmpty((String)string3) || Strings.isNullOrEmpty((String)string4)) {
            httpServerRequest.response().headers().add("Location", String.format("/login/updatepassword.html?authErrorCode=%s", new Object[]{UpdatePasswordHandler.MsgErrorCode.nullpassword}));
            httpServerRequest.response().setStatusCode(302);
            httpServerRequest.response().end();
            return;
        }
        if (!string3.equals(string4)) {
            httpServerRequest.response().headers().add("Location", String.format("/login/updatepassword.html?authErrorCode=%s", new Object[]{UpdatePasswordHandler.MsgErrorCode.passwordnotmatch}));
            httpServerRequest.response().setStatusCode(302);
            httpServerRequest.response().end();
            return;
        }
        logger.info("[{}] session: '{}' expired password update, askedUri: '{}'", new Object[]{iAuthProvider, authRequirements.sessionId, string});
        ArrayList<String> arrayList = new ArrayList<String>(httpServerRequest.headers().getAll("X-Forwarded-For"));
        arrayList.add(httpServerRequest.remoteAddress().host());
        iAuthProvider.updatePassword(authRequirements.sessionId, string2, string3, arrayList).whenComplete((void_, throwable) -> {
            HttpServerResponse httpServerResponse = httpServerRequest.response();
            if (throwable != null) {
                String string = UpdatePasswordHandler.MsgErrorCode.unknown.name();
                if (throwable instanceof ServerFault) {
                    switch (((ServerFault)throwable).getCode()) {
                        case NOT_FOUND: {
                            string = UpdatePasswordHandler.MsgErrorCode.usernotfound.name();
                            break;
                        }
                        case AUTHENTICATION_FAIL: {
                            string = UpdatePasswordHandler.MsgErrorCode.invalidpassword.name();
                            break;
                        }
                        case INVALID_PASSWORD: {
                            string = UpdatePasswordHandler.MsgErrorCode.invalidnewpassword.name();
                            try {
                                string = URLEncoder.encode(throwable.getMessage(), "utf-8");
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {}
                            break;
                        }
                        case INVALID_PARAMETER: {
                            string = UpdatePasswordHandler.MsgErrorCode.invalidParameter.name();
                            if (throwable.getMessage().equalsIgnoreCase("password must not be empty")) {
                                string = UpdatePasswordHandler.MsgErrorCode.emptyNewPassword.name();
                                break;
                            }
                            if (throwable.getMessage().equalsIgnoreCase("invalid character in password")) {
                                string = UpdatePasswordHandler.MsgErrorCode.invalidCharacterNewPassword.name();
                                break;
                            }
                            if (throwable.getMessage().equalsIgnoreCase("current and new password must not be the same")) {
                                string = UpdatePasswordHandler.MsgErrorCode.mustNotTheSame.name();
                                break;
                            }
                            try {
                                string = URLEncoder.encode(throwable.getMessage(), "utf-8");
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {}
                            break;
                        }
                    }
                }
                httpServerResponse.headers().add("Location", String.format("/login/updatepassword.html?authErrorCode=%s", string));
                httpServerResponse.setStatusCode(302);
                httpServerResponse.end();
                return;
            }
            httpServerResponse.headers().add("Location", "/bluemind_sso_logout");
            httpServerResponse.setStatusCode(302);
            httpServerResponse.end();
        });
    }

    public String getKind() {
        return "WEB";
    }
}

