/*
 * Decompiled with CFR 0.152.
 */
package net.bluemind.webmodules.login;

import freemarker.template.Configuration;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import net.bluemind.config.Token;
import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.api.BMVersion;
import net.bluemind.core.rest.http.HttpClientProvider;
import net.bluemind.core.rest.http.ILocator;
import net.bluemind.core.rest.http.ITaggedServiceProvider;
import net.bluemind.core.rest.http.VertxServiceProvider;
import net.bluemind.hornetq.client.MQ;
import net.bluemind.network.topology.Topology;
import net.bluemind.server.api.Server;
import net.bluemind.system.api.IInstallationAsync;
import net.bluemind.system.api.InstallationVersion;
import net.bluemind.system.api.SysConfKeys;
import net.bluemind.webmodule.server.NeedVertx;
import net.bluemind.webmodule.server.handlers.AbstractIndexHandler;
import net.bluemind.webmodules.login.CSRFTokenManager;
import net.bluemind.webmodules.login.MessageResolverMethod;
import net.bluemind.webmodules.login.services.ReadDomainsSettingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginHandler
extends AbstractIndexHandler
implements NeedVertx {
    private static final Logger logger = LoggerFactory.getLogger(LoginHandler.class);
    static Configuration cfg = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
    private static final String defaultLanguage = "en";
    private Vertx vertx;
    private HttpClientProvider clientProvider;
    private InstallationVersion version;
    private Supplier<Optional<String>> defaultDomain;

    static {
        cfg.setClassForTemplateLoading(LoginHandler.class, "/templates");
        cfg.setTagSyntax(0);
    }

    public LoginHandler() {
        AtomicReference atomicReference = new AtomicReference();
        MQ.init().thenAccept(void_ -> atomicReference.set(MQ.sharedMap((String)"system.configuration")));
        this.defaultDomain = () -> Optional.ofNullable((MQ.SharedMap)atomicReference.get()).map(sharedMap -> Optional.ofNullable(sharedMap.get((Object)SysConfKeys.default_domain.name()) != null && !((String)sharedMap.get((Object)SysConfKeys.default_domain.name())).isEmpty() ? (String)sharedMap.get((Object)SysConfKeys.default_domain.name()) : null)).orElse(Optional.empty());
    }

    protected String getTemplateName() {
        return "login.xml";
    }

    private Optional<String> getDefaultDomain(String string) {
        return Optional.ofNullable(ReadDomainsSettingService.getInstance().getDefaultDomain(string).orElseGet(() -> this.defaultDomain.get().orElse(null)));
    }

    protected void loadPageModel(HttpServerRequest httpServerRequest, Map<String, Object> map) {
        String string22;
        super.loadPageModel(httpServerRequest, map);
        String string3 = CSRFTokenManager.INSTANCE.initRequest(httpServerRequest);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("OSGI-INF/l10n/bundle", new Locale(this.getLang(httpServerRequest)));
        if (httpServerRequest.path().endsWith("native")) {
            map.put("actionPath", "native");
        } else {
            map.put("actionPath", "index.html");
        }
        map.put("csrfToken", string3);
        map.put("storedRequestId", "x");
        boolean bl = true;
        String string4 = httpServerRequest.headers().get(HttpHeaders.COOKIE);
        if (string4 != null) {
            for (String string22 : ServerCookieDecoder.LAX.decode(string4)) {
                if (!"BMPRIVACY".equalsIgnoreCase(string22.name())) continue;
                bl = "true".equals(string22.value());
                break;
            }
        }
        if ((string22 = httpServerRequest.params().get("userLogin")) == null) {
            string22 = "";
        }
        map.put("userLogin", string22);
        String string5 = httpServerRequest.params().get("authErrorCode");
        if (string5 != null && !string5.isEmpty()) {
            if (string5.equals("1") || string5.equals("2")) {
                map.put("authErrorMsg", resourceBundle.getString("login.error.1"));
            } else {
                map.put("authErrorMsg", resourceBundle.getString("login.error.10"));
            }
        }
        map.put("priv", "" + bl);
        String string6 = httpServerRequest.params().get("askedUri");
        if (string6 == null) {
            string6 = "/";
        } else {
            try {
                new URI(string6);
            }
            catch (URISyntaxException uRISyntaxException) {
                logger.warn("asked uri is not un uri : {} ", (Object)string6, (Object)uRISyntaxException);
                string6 = "/";
            }
        }
        map.put("askedUri", string6);
        if (this.version != null) {
            map.put("bmVersion", this.version.versionName);
            map.put("buildVersion", this.version.softwareVersion);
            if (!this.version.softwareVersion.equals(this.version.databaseVersion)) {
                map.put("version-not-ok", true);
            } else {
                map.put("version-not-ok", false);
            }
        } else {
            logger.warn("version is not available, use bundle version");
            map.put("bmVersion", BMVersion.getVersionName());
            map.put("buildVersion", BMVersion.getVersion());
        }
        this.getDefaultDomain(httpServerRequest.host().split(":")[0]).ifPresent(string -> {
            String string2 = map.put("defaultDomain", string);
        });
        map.put("msg", new MessageResolverMethod(resourceBundle, new Locale(this.getLang(httpServerRequest))));
        logger.debug("display login page with model {}", map);
    }

    protected String getLang(HttpServerRequest httpServerRequest) {
        String string = httpServerRequest.headers().get("Accept-Language");
        if (string == null) {
            return defaultLanguage;
        }
        return Locale.LanguageRange.parse(string).stream().map(languageRange -> Locale.forLanguageTag(languageRange.getRange())).findFirst().orElse(new Locale.Builder().setLanguage(defaultLanguage).build()).getLanguage().toLowerCase();
    }

    private ITaggedServiceProvider getProvider() {
        ILocator iLocator = (string, asyncHandler) -> {
            String string2 = Topology.getIfAvailable().flatMap(iServiceTopology -> iServiceTopology.anyIfPresent(string).map(itemValue -> ((Server)itemValue.value).address())).orElse("127.0.0.1");
            asyncHandler.success((Object)new String[]{string2});
        };
        return new VertxServiceProvider(this.clientProvider, iLocator, Token.admin0());
    }

    public void setVertx(Vertx vertx) {
        this.vertx = vertx;
        this.clientProvider = new HttpClientProvider(vertx);
        this.loadVersion();
    }

    private void loadVersion() {
        this.vertx.setTimer(2000L, l -> ((IInstallationAsync)this.getProvider().instance("bm/core", IInstallationAsync.class, new String[0])).getVersion((AsyncHandler)new AsyncHandler<InstallationVersion>(){

            public void success(InstallationVersion installationVersion) {
                LoginHandler.this.version = installationVersion;
            }

            public void failure(Throwable throwable) {
                logger.error("error retrieving installation version (message:{}), try again ", (Object)throwable.getMessage());
                LoginHandler.this.loadVersion();
            }
        }));
    }
}

