/*
 * Decompiled with CFR 0.152.
 */
package net.bluemind.webmodules.login;

import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import io.vertx.core.http.HttpServerRequest;
import java.util.Set;
import java.util.UUID;
import net.bluemind.proxy.http.auth.api.SecurityConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSRFTokenManager {
    public static final CSRFTokenManager INSTANCE = new CSRFTokenManager();
    private static final Logger logger = LoggerFactory.getLogger(CSRFTokenManager.class);

    public String initRequest(HttpServerRequest httpServerRequest) {
        String string = UUID.randomUUID().toString();
        DefaultCookie defaultCookie = new DefaultCookie("HPSSESSION", string);
        defaultCookie.setPath("/");
        if (SecurityConfig.secureCookies) {
            defaultCookie.setSecure(true);
        }
        defaultCookie.setHttpOnly(true);
        httpServerRequest.response().headers().add("Set-Cookie", ServerCookieEncoder.LAX.encode((Cookie)defaultCookie));
        return string;
    }

    public boolean checkToken(HttpServerRequest httpServerRequest, String string) {
        String string2 = this.currentSessionId(httpServerRequest);
        if (string2 == null) {
            logger.debug("no session to check csrfToken");
            return false;
        }
        try {
            UUID.fromString(string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.debug("invalid sessionId {}", (Object)string2, (Object)illegalArgumentException);
            return false;
        }
        boolean bl = string2.equals(string);
        if (!bl) {
            logger.warn("CSRF token check fail: csrfToken {}, sessionID {} ", (Object)string, (Object)string2);
        }
        return bl;
    }

    private String currentSessionId(HttpServerRequest httpServerRequest) {
        String string = null;
        String string2 = httpServerRequest.headers().get("Cookie");
        if (string2 != null) {
            Set set = ServerCookieDecoder.LAX.decode(string2);
            for (Cookie cookie : set) {
                if (!"HPSSESSION".equals(cookie.name())) continue;
                string = cookie.value();
                break;
            }
        }
        return string;
    }
}

