import Vue from "vue";
import { extensions } from "@bluemind/extensions";
import injector from "@bluemind/inject";
import { TranslationRegistry } from "@bluemind/i18n";
import { AttachmentClient } from "@bluemind/attachment.api";
import AddAttachmentsHandler from "~/handlers/AddAttachmentsHandler";
import RemoveAttachmentHandler from "~/handlers/RemoveAttachmentHandler";
import FileHostingAttachment from "~/components/FileHostingAttachment";
import RenderlessStore from "~/components/RenderlessStore";
import CloudIcon from "~/components/CloudIcon";
import DetachButton from "~/components/DetachButton";
import FilehostingL10N from "./l10n";
TranslationRegistry.register(FilehostingL10N);

Vue.component("FilehostingAttachment", FileHostingAttachment);
Vue.component("CloudIcon", CloudIcon);
Vue.component("DetachButton", DetachButton);
Vue.component("FhRenderlessStore", RenderlessStore);

extensions.register("webapp", "net.bluemind.webmodules.filehosting", {
    command: {
        name: "add-attachments",
        fn: AddAttachmentsHandler,
        role: "canRemoteAttach"
    }
});

extensions.register("webapp", "net.bluemind.webmodules.filehosting", {
    command: {
        name: "remove-attachment",
        fn: RemoveAttachmentHandler,
        role: "canRemoteAttach",
        after: true
    }
});

extensions.register("webapp.mail", "net.bluemind.webmodules.filehosting", {
    component: {
        name: "filehosting-attachment",
        path: "message.attachment"
    }
});

extensions.register("webapp.mail", "net.bluemind.webmodules.filehosting", {
    component: {
        name: "cloud-icon",
        path: "attachment.infos.tags"
    }
});

extensions.register("webapp.mail", "net.bluemind.webmodules.filehosting", {
    component: {
        name: "detach-button",
        path: "composer.footer.toolbar",
        role: "canRemoteAttach"
    }
});

extensions.register("webapp.mail", "net.bluemind.webmodules.filehosting", {
    component: {
        name: "fh-renderless-store",
        path: "app.header"
    }
});

injector.register({
    provide: "AttachmentPersistence",
    factory: () => {
        const userSession = injector.getProvider("UserSession").get();
        return new AttachmentClient(userSession.sid, userSession.domain);
    }
});
