/*
 * Decompiled with CFR 0.152.
 */
package net.bluemind.webmodules.calendar.handlers;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerFileUpload;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import net.bluemind.calendar.api.IVEventAsync;
import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.rest.base.GenericStream;
import net.bluemind.core.rest.http.HttpClientProvider;
import net.bluemind.core.rest.http.ILocator;
import net.bluemind.core.rest.http.VertxServiceProvider;
import net.bluemind.core.task.api.TaskRef;
import net.bluemind.network.topology.Topology;
import net.bluemind.server.api.Server;
import net.bluemind.webmodule.server.NeedVertx;

public class ImportICSHandler
implements Handler<HttpServerRequest>,
NeedVertx {
    private HttpClientProvider clientProvider;
    private static final ILocator locator = (string, asyncHandler) -> {
        String string2 = ((Server)Topology.get().core().value).address();
        String[] stringArray = new String[]{string2};
        asyncHandler.success((Object)stringArray);
    };

    public void handle(final HttpServerRequest httpServerRequest) {
        httpServerRequest.exceptionHandler(this.errorHandler(httpServerRequest));
        httpServerRequest.setExpectMultipart(true);
        httpServerRequest.uploadHandler((Handler)new Handler<HttpServerFileUpload>(){

            public void handle(HttpServerFileUpload httpServerFileUpload) {
                final Buffer buffer = Buffer.buffer();
                httpServerFileUpload.handler((Handler)new Handler<Buffer>(){

                    public void handle(Buffer buffer2) {
                        buffer.appendBuffer(buffer2);
                    }
                });
                httpServerFileUpload.endHandler((Handler)new Handler<Void>(){

                    public void handle(Void void_) {
                        ImportICSHandler.this.doImport(httpServerRequest, buffer.toString());
                    }
                });
            }
        });
    }

    private Handler<Throwable> errorHandler(final HttpServerRequest httpServerRequest) {
        return new Handler<Throwable>(){

            public void handle(Throwable throwable) {
                HttpServerResponse httpServerResponse = httpServerRequest.response();
                httpServerResponse.setStatusCode(500);
                httpServerResponse.setStatusMessage(throwable.getMessage() != null ? throwable.getMessage() : "null");
                httpServerResponse.end();
            }
        };
    }

    private void doImport(final HttpServerRequest httpServerRequest, String string2) {
        String string3 = httpServerRequest.params().get("calendar");
        VertxServiceProvider vertxServiceProvider = this.getProvider(httpServerRequest);
        IVEventAsync iVEventAsync = (IVEventAsync)vertxServiceProvider.instance("bm/core", IVEventAsync.class, new String[]{string3});
        iVEventAsync.importIcs(GenericStream.simpleValue((Object)string2, string -> string.getBytes()), (AsyncHandler)new AsyncHandler<TaskRef>(){

            public void success(TaskRef taskRef) {
                HttpServerResponse httpServerResponse = httpServerRequest.response();
                httpServerResponse.setStatusCode(200);
                httpServerResponse.end(taskRef.id);
            }

            public void failure(Throwable throwable) {
                HttpServerResponse httpServerResponse = httpServerRequest.response();
                httpServerResponse.setStatusCode(500);
                httpServerResponse.setStatusMessage(throwable.getMessage() != null ? throwable.getMessage() : "null");
                httpServerResponse.end();
            }
        });
    }

    public void setVertx(Vertx vertx) {
        this.clientProvider = new HttpClientProvider(vertx);
    }

    private VertxServiceProvider getProvider(HttpServerRequest httpServerRequest) {
        String string = httpServerRequest.headers().get("BMSessionId");
        return new VertxServiceProvider(this.clientProvider, locator, string).from(httpServerRequest);
    }
}

