/*
 * Decompiled with CFR 0.152.
 */
package net.bluemind.ui.im.client.leftpanel;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DisclosurePanel;
import com.google.gwt.user.client.ui.DockLayoutPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import net.bluemind.ui.common.client.forms.Ajax;
import net.bluemind.ui.im.client.IMConstants;
import net.bluemind.ui.im.client.IMCtrl;
import net.bluemind.ui.im.client.IScreen;
import net.bluemind.ui.im.client.conversation.CreateConversation;
import net.bluemind.ui.im.client.leftpanel.ContactList;
import net.bluemind.ui.im.client.leftpanel.Entry;
import net.bluemind.ui.im.client.leftpanel.Header;
import net.bluemind.ui.im.client.leftpanel.RosterItem;
import net.bluemind.ui.im.client.push.message.PresenceMessage;

public class LeftPanel
extends Composite
implements IScreen {
    private static LeftPanelUiBinder uiBinder = (LeftPanelUiBinder)GWT.create(LeftPanelUiBinder.class);
    public static RosterStyle style;
    public static RosterBundle bundle;
    private HashMap<String, Entry> favs;
    private HashMap<String, Entry> notInListItems;
    private IMCtrl ctrl;
    @UiField
    ContactList favorite;
    @UiField
    ContactList notInList;
    @UiField
    SimplePanel actions;
    @UiField
    Header header;
    @UiField
    Label errMsg;
    @UiField
    DisclosurePanel favoriteContainer;
    @UiField
    DisclosurePanel notInListContainer;

    public LeftPanel() {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.setHeight("100%");
        this.notInListContainer.setVisible(false);
        this.notInListContainer.setOpen(true);
        this.favoriteContainer.setOpen(true);
        this.ctrl = IMCtrl.getInstance();
        bundle = (RosterBundle)GWT.create(RosterBundle.class);
        style = bundle.getStyle();
        style.ensureInjected();
        this.favs = new HashMap();
        this.notInListItems = new HashMap();
        this.setStyleName(style.panel());
        this.actions.setStyleName(style.actions());
        this.errMsg.setStyleName(style.connectionErr());
        Button button = new Button(IMConstants.INST.newConversationButton());
        button.setStyleName("button primary");
        button.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent clickEvent) {
                CreateConversation createConversation = LeftPanel.this.ctrl.getCreateConversationsScreen();
                Widget widget = (Widget)clickEvent.getSource();
                int n = widget.getAbsoluteLeft();
                int n2 = widget.getAbsoluteTop() + 30;
                createConversation.setPopupPosition(n, n2);
                createConversation.show();
            }
        });
        this.actions.add((Widget)button);
    }

    public void addFavoriteItem(RosterItem rosterItem) {
        if (!this.favs.containsKey(rosterItem.user)) {
            Entry entry = new Entry(rosterItem);
            this.favs.put(rosterItem.user, entry);
            this.favorite.add(entry);
            this.removeFromNotInList(rosterItem.user);
        }
    }

    public void removeFavoriteItem(String string) {
        Entry entry = this.favs.get(string);
        if (entry != null) {
            this.favorite.remove(entry);
            this.favs.remove(string);
        }
    }

    public void updatePresence(RosterItem rosterItem) {
        Entry entry = this.favs.get(rosterItem.user);
        if (entry != null) {
            entry.updatePresence(rosterItem);
        }
    }

    public void updateOwnPresence(PresenceMessage presenceMessage) {
        this.header.updatePresence(presenceMessage);
    }

    public void addNotInList(String string) {
        if (!this.favs.containsKey(string) && !this.notInListItems.containsKey(string)) {
            RosterItem rosterItem = new RosterItem();
            rosterItem.user = string;
            rosterItem.name = string;
            Entry entry = new Entry(rosterItem);
            entry.setSubscribeAction();
            this.notInListItems.put(string, entry);
            this.notInList.add(entry);
            this.notInListContainer.setVisible(true);
        }
    }

    public void removeFromNotInList(String string) {
        Entry entry = this.notInListItems.get(string);
        if (entry != null) {
            this.notInList.remove(entry);
            this.notInListItems.remove(string);
        }
        if (this.notInListItems.size() == 0) {
            this.notInListContainer.setVisible(false);
        }
    }

    public void updatePhoneStatus(String string, String string2) {
        if (string.equals(Ajax.getDefaultEmail())) {
            this.header.updatePhoneStatus(string2);
        } else {
            for (Entry entry : this.favs.values()) {
                if (!entry.getLatd().equals(string)) continue;
                entry.updatePhoneStatus(string2);
            }
        }
    }

    static interface LeftPanelUiBinder
    extends UiBinder<DockLayoutPanel, LeftPanel> {
    }

    public static interface RosterBundle
    extends ClientBundle {
        @ClientBundle.Source(value={"LeftPanel.css"})
        public RosterStyle getStyle();
    }

    public static interface RosterStyle
    extends CssResource {
        public String panel();

        public String actions();

        public String connectionErr();
    }
}

