/*
 * Decompiled with CFR 0.152.
 */
package net.bluemind.ui.im.client.leftpanel;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import net.bluemind.core.api.AsyncHandler;
import net.bluemind.cti.api.Status;
import net.bluemind.cti.api.gwt.endpoint.ComputerTelephonyIntegrationGwtEndpoint;
import net.bluemind.ui.common.client.forms.Ajax;
import net.bluemind.ui.im.client.IMConstants;
import net.bluemind.ui.im.client.IMCtrl;
import net.bluemind.ui.im.client.Photo;
import net.bluemind.ui.im.client.leftpanel.RosterItem;
import net.bluemind.ui.im.client.leftpanel.StatusBundle;
import net.bluemind.ui.im.client.leftpanel.StatusStyle;

public class Entry
extends FocusPanel {
    private static EntryUiBinder uiBinder = (EntryUiBinder)GWT.create(EntryUiBinder.class);
    private static EntryStyle style;
    private static EntryBundle bundle;
    private static StatusBundle statusBundle;
    private static StatusStyle statusStyle;
    private ClickHandler createConversationClickHandler;
    private HandlerRegistration handler;
    private String jabberId;
    private String latd;
    @UiField
    Photo photo;
    @UiField
    SimplePanel statusIM;
    @UiField
    Label statusPhone;
    @UiField
    Label subscriptionAction;
    @UiField
    SimplePanel photoContainer;
    @UiField
    FlowPanel infos;
    @UiField
    Label displayName;
    @UiField
    Label statusLabel;
    @UiField
    Label resendSubscriptionRequest;
    private String imBubbleStyle;

    public Entry(RosterItem rosterItem) {
        StringBuilder stringBuilder;
        this.setWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.subscriptionAction.setVisible(false);
        this.setSubscriptionActionMouseHandler();
        this.jabberId = rosterItem.user;
        this.latd = rosterItem.latd;
        bundle = (EntryBundle)GWT.create(EntryBundle.class);
        style = bundle.getStyle();
        style.ensureInjected();
        statusBundle = (StatusBundle)GWT.create(StatusBundle.class);
        statusStyle = statusBundle.getStyle();
        statusStyle.ensureInjected();
        this.setStyleName(style.entry());
        this.photoContainer.setStyleName(style.photoContainer());
        this.infos.setStyleName(style.infos());
        this.displayName.setStyleName(style.displayName());
        this.statusLabel.setStyleName(style.statusLabel());
        if (this.createConversationClickHandler == null) {
            this.createConversationClickHandler = new ClickHandler(){

                public void onClick(ClickEvent clickEvent) {
                    clickEvent.preventDefault();
                    IMCtrl.getInstance().createChat(Entry.this.jabberId);
                }
            };
            this.addClickHandler(this.createConversationClickHandler);
        }
        this.imBubbleStyle = statusStyle.status();
        this.displayName.setText(rosterItem.name);
        this.displayName.setTitle(rosterItem.latd);
        if (rosterItem.photo != null) {
            stringBuilder = new StringBuilder();
            stringBuilder.append("data:image/jpeg;base64,");
            stringBuilder.append(rosterItem.photo);
            this.photo.set(stringBuilder.toString(), 24);
        }
        if (Ajax.TOKEN.getRoles().contains("hasCTI")) {
            this.statusPhone.setVisible(true);
            if (rosterItem.userUid != null) {
                stringBuilder = new ComputerTelephonyIntegrationGwtEndpoint(Ajax.TOKEN.getSessionId(), new String[]{Ajax.TOKEN.getContainerUid(), rosterItem.userUid});
                stringBuilder.getStatus((AsyncHandler)new AsyncHandler<Status>(){

                    public void success(Status status) {
                        Entry.this.updatePhoneStatus(Entry.statusFromString(status));
                    }

                    public void failure(Throwable throwable) {
                        Entry.this.setPhoneUnavailable();
                    }
                });
            }
        }
        this.setUnsubscribeAction();
        if ("none".equals(rosterItem.subs) || "from".equals(rosterItem.subs)) {
            this.setIMUnknown();
        } else {
            this.setIMOffline();
        }
    }

    private void setSubscriptionActionMouseHandler() {
        this.addMouseOverHandler(new MouseOverHandler(){

            public void onMouseOver(MouseOverEvent mouseOverEvent) {
                Entry.this.subscriptionAction.setVisible(true);
            }
        });
        this.addMouseOutHandler(new MouseOutHandler(){

            public void onMouseOut(MouseOutEvent mouseOutEvent) {
                Entry.this.subscriptionAction.setVisible(false);
            }
        });
    }

    public void updatePresence(RosterItem rosterItem) {
        if ("unavailable".equals(rosterItem.subscriptionType)) {
            this.setIMOffline();
        } else {
            String string = rosterItem.mode;
            if (string == null) {
                this.setIMAvailable(rosterItem.status);
            } else if ("dnd".equals(string)) {
                this.setIMBusy(rosterItem.status);
            } else if ("away".equals(string)) {
                this.setIMAway(rosterItem.status);
            }
        }
    }

    private void setIMAvailable(String string) {
        this.resendSubscriptionRequest.setVisible(false);
        this.setStyleName(style.entry());
        this.statusIM.setStyleName(this.imBubbleStyle);
        this.statusIM.addStyleName(statusStyle.statusAvailable());
        if (string != null && !string.isEmpty()) {
            this.statusLabel.setText(string);
        } else {
            this.statusLabel.setText(IMConstants.INST.statusAvailable());
        }
    }

    private void setIMAway(String string) {
        this.resendSubscriptionRequest.setVisible(false);
        this.setStyleName(style.entry());
        this.statusIM.setStyleName(this.imBubbleStyle);
        this.statusIM.addStyleName(statusStyle.statusAway());
        if (string != null && !string.isEmpty()) {
            this.statusLabel.setText(string);
        } else {
            this.statusLabel.setText(IMConstants.INST.statusAway());
        }
    }

    private void setIMBusy(String string) {
        this.resendSubscriptionRequest.setVisible(false);
        this.setStyleName(style.entry());
        this.statusIM.setStyleName(this.imBubbleStyle);
        this.statusIM.addStyleName(statusStyle.statusBusy());
        if (string != null && !string.isEmpty()) {
            this.statusLabel.setText(string);
        } else {
            this.statusLabel.setText(IMConstants.INST.statusBusy());
        }
    }

    public void setIMOffline() {
        this.setStyleName(style.offline());
        this.statusIM.setStyleName(this.imBubbleStyle);
        this.statusIM.addStyleName(statusStyle.statusOffline());
        this.statusLabel.setStyleName(style.statusLabel());
        this.statusLabel.setText(IMConstants.INST.statusOffline());
    }

    public void setIMUnknown() {
        this.setStyleName(style.offline());
        this.statusIM.setStyleName(this.imBubbleStyle);
        this.statusIM.addStyleName(statusStyle.statusOffline());
        this.statusLabel.setStyleName(style.statusLabel());
        this.statusLabel.setText(IMConstants.INST.statusUnknown());
        this.resendSubscriptionRequest.setVisible(true);
        this.resendSubscriptionRequest.setStyleName(style.statusUnknownLabel());
        this.resendSubscriptionRequest.setText(IMConstants.INST.resendSubscriptionRequest());
        this.resendSubscriptionRequest.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent clickEvent) {
                clickEvent.stopPropagation();
                clickEvent.preventDefault();
                IMCtrl.getInstance().addBuddy(Entry.this.jabberId);
                Entry.this.resendSubscriptionRequest.setVisible(false);
            }
        });
    }

    private void setPhoneUnavailable() {
        this.statusPhone.setStyleName(statusStyle.statusPhone());
        this.statusPhone.addStyleName(statusStyle.statusPhoneOffline());
        this.statusPhone.addStyleName("fa-phone");
        this.statusPhone.addStyleName("fa");
    }

    private void setPhoneAvailable() {
        this.statusPhone.setStyleName(statusStyle.statusPhone());
        this.statusPhone.addStyleName(statusStyle.statusPhoneAvailable());
        this.statusPhone.addStyleName("fa-phone");
        this.statusPhone.addStyleName("fa");
    }

    private void setPhoneBusy() {
        this.statusPhone.setStyleName(statusStyle.statusPhone());
        this.statusPhone.addStyleName(statusStyle.statusPhoneAway());
        this.statusPhone.addStyleName("fa-phone");
        this.statusPhone.addStyleName("fa");
    }

    private void setPhoneRinging() {
        this.statusPhone.setStyleName(statusStyle.statusPhone());
        this.statusPhone.addStyleName(statusStyle.statusPhoneRinging());
        this.statusPhone.addStyleName("fa-phone");
        this.statusPhone.addStyleName("fa");
    }

    public void setSubscribeAction() {
        if (this.handler != null) {
            this.handler.removeHandler();
        }
        this.subscriptionAction.setStyleName("fa fa-star star-small");
        this.subscriptionAction.setTitle(IMConstants.INST.addToFavorites(this.jabberId));
        this.handler = this.subscriptionAction.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent clickEvent) {
                clickEvent.stopPropagation();
                clickEvent.preventDefault();
                IMCtrl.getInstance().showAddToFavoritesScreen(Entry.this.jabberId);
            }
        });
    }

    private void setUnsubscribeAction() {
        if (this.handler != null) {
            this.handler.removeHandler();
        }
        this.subscriptionAction.setStyleName("fa fa-star star-small");
        this.subscriptionAction.setTitle(IMConstants.INST.removeFromFavorites(this.jabberId));
        this.handler = this.subscriptionAction.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent clickEvent) {
                clickEvent.stopPropagation();
                clickEvent.preventDefault();
                IMCtrl.getInstance().showRemoveFromFavoritesScreen(Entry.this.jabberId);
            }
        });
    }

    public String getFullName() {
        return this.jabberId;
    }

    public String getLatd() {
        return this.latd;
    }

    public static String statusFromString(Status status) {
        if (status.phoneState == Status.PhoneState.Unknown) {
            return "UNKNOWN";
        }
        if (status.phoneState == Status.PhoneState.Ringing) {
            return "RINGING";
        }
        return status.type.code();
    }

    public void updatePhoneStatus(String string) {
        if ("RINGING".equals(string)) {
            this.setPhoneRinging();
        } else if ("BUSY".equals(string) || "CALLING".equals(string)) {
            this.setPhoneBusy();
        } else if ("AVAILABLE".equals(string)) {
            this.setPhoneAvailable();
        } else {
            this.setPhoneUnavailable();
        }
    }

    public static interface EntryBundle
    extends ClientBundle {
        @ClientBundle.Source(value={"Entry.css"})
        public EntryStyle getStyle();
    }

    public static interface EntryStyle
    extends CssResource {
        public String entry();

        public String offline();

        public String action();

        public String photoContainer();

        public String displayName();

        public String statusLabel();

        public String infos();

        public String statusUnknownLabel();
    }

    static interface EntryUiBinder
    extends UiBinder<FlowPanel, Entry> {
    }
}

