/*
 * Decompiled with CFR 0.152.
 */
package net.bluemind.ui.im.client.conversation;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.dom.client.ScrollEvent;
import com.google.gwt.event.dom.client.ScrollHandler;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONString;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DockLayoutPanel;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.Widget;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import net.bluemind.im.api.IMMessage;
import net.bluemind.ui.common.client.forms.Ajax;
import net.bluemind.ui.im.client.IMConstants;
import net.bluemind.ui.im.client.IMCtrl;
import net.bluemind.ui.im.client.RosterItemCache;
import net.bluemind.ui.im.client.chatroom.RoomOccupant;
import net.bluemind.ui.im.client.conversation.Conversations;
import net.bluemind.ui.im.client.conversation.CreateConversation;
import net.bluemind.ui.im.client.conversation.Message;
import net.bluemind.ui.im.client.leftpanel.RosterItem;
import net.bluemind.ui.im.client.push.Push;

public class Conversation
extends Composite
implements HasClickHandlers {
    private static ConversationUiBinder uiBinder = (ConversationUiBinder)GWT.create(ConversationUiBinder.class);
    @UiField
    DockLayoutPanel dlp;
    @UiField
    ScrollPanel container;
    @UiField
    FlowPanel conversationPanel;
    @UiField
    FlowPanel composer;
    @UiField
    TextArea input;
    @UiField
    FlowPanel roomOccupants;
    @UiField
    Label notifyNewMessage;
    @UiField
    FlowPanel toolbar;
    private static final int NEW_MESSAGE_DELAY = 60000;
    private DateTimeFormat dateFormat;
    private DateTimeFormat timeFormat;
    private DateTimeFormat dateTimeFormat;
    private Message lastSent;
    private Message lastReceived;
    private String lastFrom;
    private List<Message> unread;
    protected static ConversationStyle style;
    private static ConversationBundle bundle;
    protected String jabberId;
    protected String id;

    public Conversation(String string, String string2) {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.notifyNewMessage.setVisible(false);
        this.dateFormat = DateTimeFormat.getFormat((String)"yyyy-MM-dd");
        this.timeFormat = DateTimeFormat.getFormat((String)"HH:mm");
        this.dateTimeFormat = DateTimeFormat.getFormat((String)"EEE dd MMM, HH:mm");
        bundle = (ConversationBundle)GWT.create(ConversationBundle.class);
        style = bundle.getStyle();
        style.ensureInjected();
        this.id = string;
        this.jabberId = string2;
        this.setStyleName(style.conversation());
        this.roomOccupants.setStyleName(style.roomOccupants());
        this.container.setStyleName(style.msgContainer());
        this.composer.setStyleName(style.composer());
        this.composer.getElement().getStyle().setPosition(Style.Position.RELATIVE);
        this.toolbar.setStyleName(style.toolbar());
        this.input.getElement().setAttribute("placeholder", IMConstants.INST.sendMessagePlaceholder());
        this.unread = new LinkedList<Message>();
        this.input.addKeyPressHandler(new KeyPressHandler(){

            public void onKeyPress(KeyPressEvent keyPressEvent) {
                if (keyPressEvent.getNativeEvent().getKeyCode() == 13 && !keyPressEvent.isShiftKeyDown()) {
                    keyPressEvent.preventDefault();
                    if (Conversation.this.input.getValue() != null && !Conversation.this.input.getValue().isEmpty()) {
                        IMCtrl.getInstance().sendMessage(Conversation.this.id, Conversation.this.input.getValue());
                        Conversation.this.input.setValue(null);
                    }
                }
            }
        });
        this.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent clickEvent) {
                Conversation.this.markAllAsRead();
                if (!Conversation.this.isTextSelected()) {
                    Conversation.this.setFocus();
                }
            }
        });
        this.notifyNewMessage.setStyleName(style.notifyNewMessage());
        this.notifyNewMessage.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent clickEvent) {
                clickEvent.stopPropagation();
                Conversation.this.container.scrollToBottom();
            }
        });
        this.container.addScrollHandler(new ScrollHandler(){

            public void onScroll(ScrollEvent scrollEvent) {
                if (Conversation.this.container.getMaximumVerticalScrollPosition() == Conversation.this.container.getVerticalScrollPosition()) {
                    Conversation.this.notifyNewMessage.setVisible(false);
                }
            }
        });
        Window.addResizeHandler((ResizeHandler)new ResizeHandler(){

            public void onResize(ResizeEvent resizeEvent) {
                Conversations conversations = IMCtrl.getInstance().getConversationsScreen();
                if (conversations.getActiveConversation().equals(Conversation.this.id)) {
                    Conversation.this.computeLayoutAndScrollToBottom();
                }
            }
        });
        this.inviteButton();
    }

    private native boolean isTextSelected();

    public String getId() {
        return this.id;
    }

    public String getJabberId() {
        return this.jabberId;
    }

    public List<Message> getUnread() {
        return this.unread;
    }

    public void markAllAsRead() {
        if (this.unread.size() > 0) {
            for (Message message : this.unread) {
                message.markAsRead();
            }
            this.unread.clear();
            IMCtrl.getInstance().markAsRead(this.id);
        }
    }

    public void setFocus() {
        this.input.setFocus(true);
        this.computeLayoutAndScrollToBottom();
    }

    public HandlerRegistration addClickHandler(ClickHandler clickHandler) {
        return this.addDomHandler((EventHandler)clickHandler, ClickEvent.getType());
    }

    private void scrollOrNotify(boolean bl, String string) {
        if (bl) {
            this.container.scrollToBottom();
        } else {
            if (string.length() >= 50) {
                string = String.valueOf(string.substring(0, 50)) + " ...";
            }
            this.notifyNewMessage.setText("\u2193 " + string + " \u2193");
        }
        this.notifyNewMessage.setVisible(!bl);
    }

    private void computeLayoutAndScrollToBottom() {
        this.dlp.forceLayout();
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                Conversation.this.container.scrollToBottom();
            }
        });
    }

    public void addParticipant(String string) {
        RoomOccupant roomOccupant = new RoomOccupant(string);
        roomOccupant.addStyleName("c1");
        this.roomOccupants.add((Widget)roomOccupant);
    }

    protected void inviteButton() {
        Label label = new Label();
        label.setSize("12px", "12px");
        label.setStyleName("fa fa-lg fa-plus-square-o add-invitee-sign");
        label.setTitle(IMConstants.INST.inviteToGroupChat());
        label.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent clickEvent) {
                CreateConversation createConversation = IMCtrl.getInstance().getCreateConversationsScreen();
                Widget widget = (Widget)clickEvent.getSource();
                int n = widget.getAbsoluteLeft() - 40;
                int n2 = widget.getAbsoluteTop() + 24;
                createConversation.setPopupPosition(n, n2);
                createConversation.show();
                createConversation.addToInvitees(Conversation.this.jabberId);
            }
        });
        this.roomOccupants.add((Widget)label);
    }

    public void receiveMessage(String string, String string2) {
        boolean bl = false;
        if (this.container.getMaximumVerticalScrollPosition() == this.container.getVerticalScrollPosition()) {
            bl = true;
        }
        this.appendMessage(string, string2, new Date());
        if (!this.getJID().equals(string)) {
            this.lastReceived.setUnread();
            this.unread.add(this.lastReceived);
            this.scrollOrNotify(bl, String.valueOf(string) + ": " + string2);
        } else {
            this.container.scrollToBottom();
        }
    }

    private String getJID() {
        return Ajax.getDefaultEmail();
    }

    public void loadFromHistory(List<IMMessage> list, boolean bl) {
        if (list != null) {
            for (IMMessage iMMessage : list) {
                this.appendMessage(iMMessage.from, iMMessage.body, iMMessage.timestamp);
            }
            this.container.scrollToBottom();
            if (bl) {
                this.lastReceived.setUnread();
                this.unread.add(this.lastReceived);
            }
        }
    }

    private void appendMessage(String string, String string2, Date date) {
        if (string2.startsWith("/me ")) {
            this.me(string, string2);
            return;
        }
        Message message = new Message();
        message.setTimestamp(date);
        message.appendMessage(string2);
        Date date2 = new Date();
        if (this.dateFormat.format(date2).equals(this.dateFormat.format(date))) {
            message.setDate(this.timeFormat.format(date));
        } else {
            message.setDate(this.dateTimeFormat.format(date));
        }
        RosterItem rosterItem = (RosterItem)RosterItemCache.getInstance().get(string);
        if (rosterItem != null) {
            if (rosterItem.photo != null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("data:image/jpeg;base64,");
                stringBuilder.append(rosterItem.photo);
                message.setPicture(stringBuilder.toString());
            }
            message.setHeaderText(rosterItem.name);
        } else {
            message.setHeaderText(string);
        }
        if (this.lastFrom == null && this.lastReceived == null || message.getTimestamp().getTime() - this.lastReceived.getTimestamp().getTime() > 60000L || !this.lastFrom.equals(string)) {
            this.conversationPanel.add((Widget)message);
            this.lastReceived = message;
        } else {
            this.lastReceived.appendMessage(string2);
        }
        this.lastFrom = string;
        this.lastReceived.setColor(this.getColor(string));
        this.lastSent = null;
    }

    private void me(String string, String string2) {
        RosterItem rosterItem;
        boolean bl = false;
        if (this.container.getMaximumVerticalScrollPosition() == this.container.getVerticalScrollPosition()) {
            bl = true;
        }
        if ((rosterItem = (RosterItem)RosterItemCache.getInstance().get(string)) != null) {
            string = rosterItem.name;
        }
        string2 = string2.replace("/me ", String.valueOf(string) + " ");
        Label label = new Label(string2);
        label.setStyleName(style.me());
        this.conversationPanel.add((Widget)label);
        this.scrollOrNotify(bl, string2);
        this.lastSent = null;
        this.lastReceived = null;
        this.lastFrom = null;
    }

    protected int getColor(String string) {
        int n = 0;
        if (!string.equals(this.getJID())) {
            n = 1;
        }
        return n;
    }

    public void sendMessage(String string) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("message", (JSONValue)new JSONString(string));
        Push.send("xmpp/session/" + Push.getSidFromPage() + "/chat/" + this.id + ":message", jSONObject);
        this.container.scrollToBottom();
        this.markAllAsRead();
    }

    public void info(String string) {
        boolean bl = false;
        if (this.container.getMaximumVerticalScrollPosition() == this.container.getVerticalScrollPosition()) {
            bl = true;
        }
        Label label = new Label(string);
        label.setStyleName(style.info());
        this.conversationPanel.add((Widget)label);
        this.scrollOrNotify(bl, string);
        this.lastSent = null;
        this.lastReceived = null;
        this.lastFrom = null;
    }

    public void errorMessage(String string) {
        boolean bl = false;
        if (this.container.getMaximumVerticalScrollPosition() == this.container.getVerticalScrollPosition()) {
            bl = true;
        }
        Label label = new Label(string);
        label.setStyleName(style.error());
        this.conversationPanel.add((Widget)label);
        this.scrollOrNotify(bl, string);
        this.lastSent = null;
        this.lastReceived = null;
        this.lastFrom = null;
    }

    public static interface ConversationBundle
    extends ClientBundle {
        @ClientBundle.Source(value={"Conversation.css"})
        public ConversationStyle getStyle();
    }

    public static interface ConversationStyle
    extends CssResource {
        public String composer();

        public String toolbar();

        public String error();

        public String info();

        public String me();

        public String msgContainer();

        public String conversation();

        public String invite();

        public String disabled();

        public String notifyNewMessage();

        public String roomOccupants();
    }

    static interface ConversationUiBinder
    extends UiBinder<DockLayoutPanel, Conversation> {
    }
}

