/*
 * Decompiled with CFR 0.152.
 */
package net.bluemind.ui.im.client;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONString;
import com.google.gwt.json.client.JSONValue;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.AsyncHandler;
import net.bluemind.im.api.IMMessage;
import net.bluemind.im.api.gwt.endpoint.InstantMessagingGwtEndpoint;
import net.bluemind.ui.common.client.forms.Ajax;
import net.bluemind.ui.im.client.IMConstants;
import net.bluemind.ui.im.client.IScreen;
import net.bluemind.ui.im.client.Overlay;
import net.bluemind.ui.im.client.RosterItemCache;
import net.bluemind.ui.im.client.chatroom.InviteToChatroom;
import net.bluemind.ui.im.client.chatroom.NewInvitation;
import net.bluemind.ui.im.client.chatroom.SendHistory;
import net.bluemind.ui.im.client.conversation.BMMessageEvent;
import net.bluemind.ui.im.client.conversation.Conversation;
import net.bluemind.ui.im.client.conversation.ConversationMessageHandler;
import net.bluemind.ui.im.client.conversation.ConversationMessageListener;
import net.bluemind.ui.im.client.conversation.Conversations;
import net.bluemind.ui.im.client.conversation.CreateConversation;
import net.bluemind.ui.im.client.conversation.MucConversation;
import net.bluemind.ui.im.client.leftpanel.LeftPanel;
import net.bluemind.ui.im.client.leftpanel.RosterItem;
import net.bluemind.ui.im.client.push.MessageHandler;
import net.bluemind.ui.im.client.push.Push;
import net.bluemind.ui.im.client.push.message.ChatMessage;
import net.bluemind.ui.im.client.push.message.ErrorMessage;
import net.bluemind.ui.im.client.push.message.MucMessage;
import net.bluemind.ui.im.client.push.message.PhoneMessage;
import net.bluemind.ui.im.client.push.message.PresenceMessage;
import net.bluemind.ui.im.client.push.message.RosterMessage;
import net.bluemind.ui.im.client.subscription.AddToFavorites;
import net.bluemind.ui.im.client.subscription.RemoveFromFavorites;
import net.bluemind.ui.im.client.subscription.SubscriptionRequest;

public class IMCtrl {
    private static final IMCtrl instance = new IMCtrl();
    private Map<String, IScreen> screens = new HashMap<String, IScreen>();
    private ConversationMessageListener cml = new ConversationMessageListener();

    public static IMCtrl getInstance() {
        return instance;
    }

    private IMCtrl() {
    }

    public void registerScreen(String string, IScreen iScreen) {
        this.screens.put(string, iScreen);
    }

    public void registerConversation(Conversation conversation, boolean bl) {
        Conversations conversations = this.getConversationsScreen();
        conversations.register(conversation, bl);
    }

    public void unregisterConversation(Conversation conversation) {
        if (conversation instanceof MucConversation) {
            this.leaveMuc(conversation.getJabberId());
        }
        Conversations conversations = this.getConversationsScreen();
        conversations.unregister(conversation);
    }

    public void sendMessage(String string, String string2) {
        Conversations conversations = this.getConversationsScreen();
        Conversation conversation = conversations.getFromId(string);
        if (conversation != null) {
            conversation.sendMessage(string2);
        }
    }

    public void markAsRead(String string) {
        this.cml.markAsRead(string);
    }

    public void addMessageReceivedEventHandler(ConversationMessageHandler conversationMessageHandler) {
        this.cml.addMessageReceivedEventHandler(conversationMessageHandler);
    }

    public void addMarkAsReadEventHandler(ConversationMessageHandler conversationMessageHandler) {
        this.cml.addMarkAsReadEventHandler(conversationMessageHandler);
    }

    public void showSendHistoryDialog(String string) {
        SendHistory sendHistory = (SendHistory)this.screens.get("sendHistory");
        sendHistory.setRoomName(string);
        sendHistory.center();
        sendHistory.show();
    }

    public void sendHistory(String string, final String string2) {
        Conversations conversations = this.getConversationsScreen();
        final Conversation conversation = conversations.getFromId(string);
        InstantMessagingGwtEndpoint instantMessagingGwtEndpoint = new InstantMessagingGwtEndpoint(Ajax.TOKEN.getSessionId(), new String[0]);
        instantMessagingGwtEndpoint.sendGroupChatHistory(Ajax.getDefaultEmail(), string, Arrays.asList(string2), (AsyncHandler)new AsyncHandler<Void>(){

            public void success(Void void_) {
                conversation.info(IMConstants.INST.groupChatHistoryWasSentTo(string2));
            }

            public void failure(Throwable throwable) {
            }
        });
    }

    public LeftPanel getLeftPanelScreen() {
        return (LeftPanel)this.screens.get("leftPanel");
    }

    public Conversations getConversationsScreen() {
        return (Conversations)this.screens.get("conversations");
    }

    public CreateConversation getCreateConversationsScreen() {
        return (CreateConversation)this.screens.get("createConversation");
    }

    public InviteToChatroom getInviteToChatroomScreen() {
        return (InviteToChatroom)this.screens.get("inviteToChatroom");
    }

    public void messageEvent(ChatMessage chatMessage) {
        String string = chatMessage.getBody();
        if (string != null && !string.isEmpty()) {
            Conversations conversations = this.getConversationsScreen();
            Conversation conversation = conversations.getFromId(chatMessage.getThreadId());
            if (conversation == null) {
                conversation = this.chatEvent(chatMessage, true);
            } else {
                conversation.receiveMessage(chatMessage.getFrom(), chatMessage.getBody());
                if (!conversations.getActiveConversation().equals(chatMessage.getThreadId())) {
                    BMMessageEvent bMMessageEvent = new BMMessageEvent();
                    bMMessageEvent.setConvId(chatMessage.getThreadId());
                    this.cml.newMessageReceived(bMMessageEvent);
                }
            }
        }
    }

    public void errorMessage(ErrorMessage errorMessage) {
        Conversations conversations;
        Conversation conversation;
        String string = errorMessage.getBody();
        if (string != null && !string.isEmpty() && (conversation = (conversations = this.getConversationsScreen()).getFromId(errorMessage.getThreadId())) != null) {
            conversation.errorMessage(string);
        }
    }

    public Conversation chatEvent(ChatMessage chatMessage, final boolean bl) {
        final Conversation conversation = new Conversation(chatMessage.getThreadId(), chatMessage.getFrom());
        conversation.addParticipant(chatMessage.getFrom());
        this.registerConversation(conversation, true);
        LeftPanel leftPanel = this.getLeftPanelScreen();
        leftPanel.addNotInList(chatMessage.getFrom());
        InstantMessagingGwtEndpoint instantMessagingGwtEndpoint = new InstantMessagingGwtEndpoint(Ajax.TOKEN.getSessionId(), new String[0]);
        instantMessagingGwtEndpoint.getLastMessagesBetween(Ajax.getDefaultEmail(), chatMessage.getFrom(), Integer.valueOf(50), (AsyncHandler)new AsyncHandler<List<IMMessage>>(){

            public void success(List<IMMessage> list) {
                conversation.loadFromHistory(list, bl);
            }

            public void failure(Throwable throwable) {
            }
        });
        return conversation;
    }

    public void rosterEntries(List<RosterItem> list) {
        LeftPanel leftPanel = this.getLeftPanelScreen();
        for (RosterItem rosterItem : list) {
            leftPanel.addFavoriteItem(rosterItem);
            leftPanel.updatePresence(rosterItem);
        }
    }

    public void rosterEvent(RosterMessage rosterMessage) {
        LeftPanel leftPanel = this.getLeftPanelScreen();
        if ("entries-added".equals(rosterMessage.getType())) {
            Push.entries();
        } else if ("entries-deleted".equals(rosterMessage.getType())) {
            int n = 0;
            while (n < rosterMessage.getEntries().length()) {
                leftPanel.removeFavoriteItem(rosterMessage.getEntries().get(n));
                ++n;
            }
        } else if ("presence".equals(rosterMessage.getType())) {
            RosterItem rosterItem = new RosterItem();
            rosterItem.user = rosterMessage.getUser();
            rosterItem.mode = rosterMessage.getMode();
            rosterItem.subs = rosterMessage.getSubs();
            rosterItem.status = rosterMessage.getPresenceStatus();
            rosterItem.subscriptionType = rosterMessage.getSubscriptionType();
            leftPanel.updatePresence(rosterItem);
        }
    }

    public void createChat(String string) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("userJID", (JSONValue)new JSONString(string));
        Push.send("xmpp/session/" + Push.getSidFromPage() + ":chat", jSONObject);
    }

    public void setPresence(String string, String string2) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("mode", (JSONValue)new JSONString(string));
        jSONObject.put("status", (JSONValue)new JSONString(string2));
        Push.send("xmpp/session/" + Push.getSidFromPage() + ":presence", jSONObject);
    }

    public void showRemoveFromFavoritesScreen(String string) {
        RemoveFromFavorites removeFromFavorites = (RemoveFromFavorites)this.screens.get("removeFromFavorites");
        removeFromFavorites.setJabberId(string);
    }

    public void showAddToFavoritesScreen(String string) {
        AddToFavorites addToFavorites = (AddToFavorites)this.screens.get("addToFavorites");
        addToFavorites.setJabberId(string);
    }

    public void addBuddy(String string) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("user", (JSONValue)new JSONString(string));
        Push.send("xmpp/session/" + Push.getSidFromPage() + "/roster:add-buddy", jSONObject);
    }

    public void removeBuddy(String string) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("user", (JSONValue)new JSONString(string));
        Push.send("xmpp/session/" + Push.getSidFromPage() + "/roster:remove-buddy", jSONObject);
    }

    public void presenceEvent(PresenceMessage presenceMessage) {
        if ("subscribe".equals(presenceMessage.getAction())) {
            SubscriptionRequest subscriptionRequest = (SubscriptionRequest)this.screens.get("subscriptionRequest");
            subscriptionRequest.setJabberId(presenceMessage.getFrom());
        }
    }

    public void acceptSubscribe(String string) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("to", (JSONValue)new JSONString(string));
        Push.send("xmpp/session/" + Push.getSidFromPage() + ":accept-subscribe", jSONObject);
        this.addBuddy(string);
        this.markAllAsRead();
    }

    public void discardSubscribe(String string) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("to", (JSONValue)new JSONString(string));
        Push.send("xmpp/session/" + Push.getSidFromPage() + ":discard-subscribe", jSONObject);
        this.markAllAsRead();
    }

    public void createMuc(final Set<String> set) {
        JSONObject jSONObject = new JSONObject();
        String string = "groupchat-" + System.currentTimeMillis();
        jSONObject.put("name", (JSONValue)new JSONString(string));
        jSONObject.put("nickname", (JSONValue)new JSONString(Ajax.getDefaultEmail()));
        Push.send("xmpp/muc/" + Push.getSidFromPage() + ":create", jSONObject, new MessageHandler<JavaScriptObject>(){

            @Override
            public void onMessage(JavaScriptObject javaScriptObject) {
                JSONObject jSONObject = new JSONObject(javaScriptObject);
                double d = jSONObject.get("status").isNumber().doubleValue();
                if (d == 0.0) {
                    String string = jSONObject.get("roomName").isString().stringValue();
                    MucConversation mucConversation = new MucConversation(string);
                    IMCtrl.this.registerConversation(mucConversation, true);
                    IMCtrl.this.sendMucInvitations(set, string);
                }
            }
        });
    }

    public void sendMucInvitations(Set<String> set, String string) {
        Conversations conversations = this.getConversationsScreen();
        MucConversation mucConversation = (MucConversation)conversations.getFromId(string);
        for (String string2 : set) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("latd", (JSONValue)new JSONString(string2));
            jSONObject.put("reason", (JSONValue)new JSONString(IMConstants.INST.hasInvitedYouToGroupChat(Ajax.getDisplayName())));
            Push.send("xmpp/muc/" + Push.getSidFromPage() + "/" + string + ":invite", jSONObject);
            String string3 = string2;
            RosterItem rosterItem = (RosterItem)RosterItemCache.getInstance().get(string2);
            if (rosterItem != null) {
                string3 = rosterItem.name;
            }
            mucConversation.info(IMConstants.INST.youHaveInvited(string3));
        }
    }

    public void mucMessageEvent(MucMessage mucMessage) {
        String string = mucMessage.getMessage();
        if (string != null && !string.isEmpty()) {
            Conversations conversations = this.getConversationsScreen();
            MucConversation mucConversation = (MucConversation)conversations.getFromId(mucMessage.getThreadId());
            mucConversation.receiveMessage(mucMessage.getFrom(), mucMessage.getMessage());
            if (!conversations.getActiveConversation().equals(mucMessage.getThreadId())) {
                BMMessageEvent bMMessageEvent = new BMMessageEvent();
                bMMessageEvent.setConvId(mucMessage.getThreadId());
                this.cml.newMessageReceived(bMMessageEvent);
            }
        }
    }

    public void mucJoinEvent(MucMessage mucMessage) {
        Conversations conversations = this.getConversationsScreen();
        MucConversation mucConversation = (MucConversation)conversations.getFromId(mucMessage.getRoom());
        if (mucConversation == null) {
            mucConversation = new MucConversation(mucMessage.getRoom());
            this.registerConversation(mucConversation, true);
        }
        mucConversation.addParticipant(mucMessage.getParticipant());
    }

    public void mucLeaveEvent(MucMessage mucMessage) {
        Conversations conversations = this.getConversationsScreen();
        MucConversation mucConversation = (MucConversation)conversations.getFromId(mucMessage.getRoom());
        mucConversation.removeParticipant(mucMessage.getParticipant());
    }

    public void mucInvitationEvent(MucMessage mucMessage) {
        Conversations conversations = this.getConversationsScreen();
        Conversation conversation = conversations.getFromId(mucMessage.getInvitationRoom());
        if (conversation == null) {
            NewInvitation newInvitation = (NewInvitation)this.screens.get("newInvitation");
            newInvitation.setInvitationEvent(mucMessage);
            newInvitation.center();
            newInvitation.show();
        }
    }

    public void mucAcceptInvitation(String string) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("room", (JSONValue)new JSONString(string));
        jSONObject.put("nickname", (JSONValue)new JSONString(this.getJID()));
        Push.send("xmpp/muc/" + Push.getSidFromPage() + ":join", jSONObject);
    }

    public void leaveMuc(String string) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("room", (JSONValue)new JSONString(string));
        jSONObject.put("nickname", (JSONValue)new JSONString(this.getJID()));
        Push.send("xmpp/muc/" + Push.getSidFromPage() + "/" + string + ":leave", jSONObject);
    }

    public void updatePhoneStatus(PhoneMessage phoneMessage) {
        LeftPanel leftPanel = this.getLeftPanelScreen();
        leftPanel.updatePhoneStatus(phoneMessage.getLatd(), phoneMessage.getStatus());
    }

    public void markAllAsRead() {
        Push.send("xmpp/session/" + Push.getSidFromPage() + ":mark-all-as-read", new JSONObject());
    }

    public void loadUnreadMessage() {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("origin", (JSONValue)new JSONString("im"));
        Push.send("xmpp/session/" + Push.getSidFromPage() + ":unread", jSONObject);
    }

    public void loadPendingMuc() {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("origin", (JSONValue)new JSONString("im"));
        Push.send("xmpp/muc/" + Push.getSidFromPage() + ":pending", jSONObject);
    }

    public void open() {
        Overlay overlay = (Overlay)this.screens.get("overlay");
        overlay.hide();
    }

    public void close() {
        Object object2;
        Conversations conversations = this.getConversationsScreen();
        for (Object object2 : conversations.getConversations().values()) {
            if (!(object2 instanceof MucConversation)) continue;
            conversations.unregister((Conversation)((Object)object2));
        }
        object2 = (Overlay)this.screens.get("overlay");
        object2.show();
    }

    public void loadPresence() {
        Push.send("xmpp/session/" + Push.getSidFromPage() + ":ownPresence", new JSONObject());
    }

    public void ownPresenceEvent(PresenceMessage presenceMessage) {
        LeftPanel leftPanel = (LeftPanel)this.screens.get("leftPanel");
        leftPanel.updateOwnPresence(presenceMessage);
    }

    public void leaveMucs() {
        Push.send("xmpp/muc/" + Push.getSidFromPage() + ":close", new JSONObject());
    }

    public String getJID() {
        return Ajax.getDefaultEmail();
    }
}

