/*
 * Decompiled with CFR 0.152.
 */
package net.bluemind.ui.adminconsole.filehosting.settings;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.IntegerBox;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.bluemind.core.api.AsyncHandler;
import net.bluemind.filehosting.api.FileHostingInfo;
import net.bluemind.filehosting.api.gwt.endpoint.FileHostingGwtEndpoint;
import net.bluemind.gwtconsoleapp.base.editor.Ajax;
import net.bluemind.gwtconsoleapp.base.editor.WidgetElement;
import net.bluemind.gwtconsoleapp.base.editor.gwt.CompositeGwtWidgetElement;
import net.bluemind.gwtconsoleapp.base.editor.gwt.GwtWidgetElement;
import net.bluemind.gwtconsoleapp.base.editor.gwt.IGwtDelegateFactory;
import net.bluemind.gwtconsoleapp.base.editor.gwt.IGwtWidgetElement;
import net.bluemind.gwtconsoleapp.base.handler.DefaultAsyncHandler;
import net.bluemind.system.api.GlobalSettingsKeys;
import net.bluemind.system.api.SysConfKeys;
import net.bluemind.ui.adminconsole.system.SettingsModel;
import net.bluemind.ui.adminconsole.system.systemconf.util.ValueUtil;

public class EditFileHostingSettingsEditor
extends CompositeGwtWidgetElement {
    static final String TYPE = "bm.ac.EditDomainFilehostingEditor";
    private static final int DEFAULT_AUTO_DETACHMENT_LIMIT = 10;
    private static final int DEFAULT_MAX_DETACHMENT_SIZE_LIMIT = 100;
    private static final int DEFAULT_RETENTION = 365;
    private static EditDomainFileHostingUiBinder uiBinder = (EditDomainFileHostingUiBinder)GWT.create(EditDomainFileHostingUiBinder.class);
    @UiField
    IntegerBox retentionTime;
    @UiField
    IntegerBox detachedAttachmentSizeLimit;
    @UiField
    IntegerBox autoDetachmentLimit;
    @UiField
    CheckBox backupFileHostingData;
    @UiField
    Label noImplWarning;
    @UiField
    Label backupFileHostingDataLabel;
    private String skipTagList;
    private boolean domainConfig;

    protected EditFileHostingSettingsEditor() {
        this(false);
    }

    protected EditFileHostingSettingsEditor(boolean bl) {
        HTMLPanel hTMLPanel = (HTMLPanel)uiBinder.createAndBindUi((Object)this);
        this.domainConfig = bl;
        this.initWidget((Widget)hTMLPanel);
    }

    public void loadModel(JavaScriptObject javaScriptObject) {
        this.noImplWarning.setVisible(false);
        SettingsModel settingsModel = this.settingsModel(javaScriptObject);
        if (settingsModel.get(GlobalSettingsKeys.filehosting_retention.name()) != null) {
            this.retentionTime.setText(settingsModel.get(GlobalSettingsKeys.filehosting_retention.name()).toString());
        } else {
            this.retentionTime.setText("365");
        }
        this.detachedAttachmentSizeLimit.setText(this.readMbIntegerValue(settingsModel, GlobalSettingsKeys.filehosting_max_filesize, 100));
        this.autoDetachmentLimit.setText(this.readMbIntegerValue(settingsModel, GlobalSettingsKeys.mail_autoDetachmentLimit, 10));
        FileHostingGwtEndpoint fileHostingGwtEndpoint = new FileHostingGwtEndpoint(Ajax.TOKEN.getSessionId(), new String[]{Ajax.TOKEN.getContainerUid()});
        fileHostingGwtEndpoint.info((AsyncHandler)new DefaultAsyncHandler<FileHostingInfo>(){

            public void success(FileHostingInfo fileHostingInfo) {
                EditFileHostingSettingsEditor.this.noImplWarning.setVisible(!fileHostingInfo.present);
            }
        });
        if (this.domainConfig) {
            this.backupFileHostingData.setVisible(false);
            this.backupFileHostingDataLabel.setVisible(false);
        } else {
            this.backupFileHostingData.setValue(Boolean.valueOf(true));
            this.backupFileHostingDataLabel.setVisible(true);
            if (settingsModel.get(SysConfKeys.dpBackupSkipTags.name()) != null) {
                this.skipTagList = settingsModel.get(SysConfKeys.dpBackupSkipTags.name()).toString();
                if (this.skipTagList.contains("filehosting/data")) {
                    this.backupFileHostingData.setValue(Boolean.valueOf(false));
                }
            } else {
                this.skipTagList = "";
            }
        }
    }

    protected SettingsModel settingsModel(JavaScriptObject javaScriptObject) {
        return SettingsModel.globalSettingsFrom((JavaScriptObject)javaScriptObject);
    }

    public void saveModel(JavaScriptObject javaScriptObject) {
        String string = this.sanitizeMbIntegerValue(this.detachedAttachmentSizeLimit, 100);
        String string2 = this.sanitizeMbIntegerValue(this.autoDetachmentLimit, 10);
        SettingsModel settingsModel = this.settingsModel(javaScriptObject);
        settingsModel.putString(GlobalSettingsKeys.filehosting_retention.name(), this.sanitizeDayIntegerValue(this.retentionTime, 365));
        settingsModel.putString(GlobalSettingsKeys.filehosting_max_filesize.name(), string);
        settingsModel.putString(GlobalSettingsKeys.mail_autoDetachmentLimit.name(), string2);
        if (!this.domainConfig) {
            if (this.backupFileHostingData.getValue().booleanValue()) {
                if (this.skipTagList.contains("filehosting/data")) {
                    this.removeTag("filehosting/data");
                }
            } else if (!this.skipTagList.contains("filehosting/data")) {
                this.addTag("filehosting/data");
            }
            settingsModel.putString(SysConfKeys.dpBackupSkipTags.name(), this.skipTagList);
        }
    }

    private void addTag(String string) {
        List<String> list = this.stringList(this.skipTagList);
        list.add(string);
        this.updateTagList(list);
    }

    private void removeTag(String string) {
        List<String> list = this.stringList(this.skipTagList);
        list.remove(string);
        this.updateTagList(list);
    }

    private void updateTagList(List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : list) {
            stringBuilder.append(String.valueOf(string) + ",");
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        this.skipTagList = stringBuilder.toString();
    }

    public List<String> stringList(String string) {
        if (string == null || string.trim().length() == 0) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(Arrays.asList(string.split(",")));
    }

    private String sanitizeDayIntegerValue(IntegerBox integerBox, int n) {
        return ValueUtil.removeNonDigitCharacters((String)integerBox.getText(), (int)n);
    }

    private String readMbIntegerValue(SettingsModel settingsModel, GlobalSettingsKeys globalSettingsKeys, int n) {
        String string = null;
        string = settingsModel.get(globalSettingsKeys.name()) == null ? "" + n : settingsModel.get(globalSettingsKeys.name()).toString();
        return this.toMbyte(n, string);
    }

    private String toMbyte(int n, String string) {
        string = ValueUtil.removeNonDigitCharacters((String)string, (int)n);
        long l = Long.parseLong(string) / 0x100000L;
        return String.valueOf(l);
    }

    private String sanitizeMbIntegerValue(IntegerBox integerBox, int n) {
        try {
            float f = Math.round(Float.parseFloat(integerBox.getText()));
            long l = (long)f * 0x100000L;
            return String.valueOf(l);
        }
        catch (Exception exception) {
            return String.valueOf(n);
        }
    }

    public static void registerType() {
        GwtWidgetElement.register((String)TYPE, (IGwtDelegateFactory)new IGwtDelegateFactory<IGwtWidgetElement, WidgetElement>(){

            public IGwtWidgetElement create(WidgetElement widgetElement) {
                return new EditFileHostingSettingsEditor();
            }
        });
    }

    static interface EditDomainFileHostingUiBinder
    extends UiBinder<HTMLPanel, EditFileHostingSettingsEditor> {
    }
}

