<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * HotUpgradeTask.
 */
class HotUpgradeTask  {

  /*
   * @type int
   */
  public $id;

  /*
   * @type String
   */
  public $operation;

  /*
   * @type String
   */
  public $parameters;

  /*
   * @type HotUpgradeTaskStatus
   */
  public $status;

  /*
   * @type int
   */
  public $failure;

  /*
   * @type javautilDate
   */
  public $createdAt;

  /*
   * @type javautilDate
   */
  public $updatedAt;

  /*
   * @type HotUpgradeTaskExecutionMode
   */
  public $executionMode;

  /*
   * @type int
   */
  public $retryCount;

  /*
   * @type int
   */
  public $retryDelaySeconds;

  /*
   * @type boolean
   */
  public $reportFailure;

  /*
   * Constructor
   */
  public function __construct() {
    $this->id = 0;
    $this->operation = "";
    $this->parameters = "";
    $this->failure = 0;
    $this->createdAt = null;
    $this->updatedAt = null;
    $this->retryCount = 0;
    $this->retryDelaySeconds = 0;
    $this->reportFailure = false;
  }

  public function toMap() {
    $data = array(    
        "id" => empty($this->id) ? null : $this->id,    
        "operation" => empty($this->operation) ? null : $this->operation,    
        "parameters" => empty($this->parameters) ? null : $this->parameters,    
        "status" => empty($this->status) ? null : $this->status,    
        "failure" => empty($this->failure) ? null : $this->failure,    
        "createdAt" => empty($this->createdAt) ? null : $this->createdAt,    
        "updatedAt" => empty($this->updatedAt) ? null : $this->updatedAt,    
        "executionMode" => empty($this->executionMode) ? null : $this->executionMode,    
        "retryCount" => empty($this->retryCount) ? null : $this->retryCount,    
        "retryDelaySeconds" => empty($this->retryDelaySeconds) ? null : $this->retryDelaySeconds,    
        "reportFailure" => empty($this->reportFailure) ? null : $this->reportFailure);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
