/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2019
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.sds.proxy.launcher;

import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.bluemind.lib.vertx.VertxPlatform;
import net.bluemind.systemd.notify.SystemD;

public class SdsLauncher implements IApplication {

	private static final Logger logger = LoggerFactory.getLogger(SdsLauncher.class);

	@Override
	public Object start(IApplicationContext context) throws Exception {
		logger.info("Starting {}", context);

		VertxPlatform.spawnVerticles(spawn -> {
			if (spawn.succeeded()) {
				context.setResult(spawn.result(), this);
				if (SystemD.isAvailable()) {
					SystemD.get().notifyReady();
				}
			} else {
				logger.error(spawn.cause().getMessage(), spawn.cause());
				System.exit(1);
			}
		});

		return IApplicationContext.EXIT_ASYNC_RESULT;
	}

	@Override
	public void stop() {
		logger.info("Stopping {}", this);

	}

}
