<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * TierChangeResult.
 */
class TierChangeResult  {

  /*
   * @type String
   */
  public $hsmId;

  /*
   * @type int
   */
  public $imapId;

  /*
   * Constructor
   */
  public function __construct() {
    $this->hsmId = "";
    $this->imapId = 0;
  }

  public function toMap() {
    $data = array(    
        "hsmId" => empty($this->hsmId) ? null : $this->hsmId,    
        "imapId" => empty($this->imapId) ? null : $this->imapId);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
