<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * Job.
 */
class Job  {

  /*
   * @type List
   */
  public $domainStatus;

  /*
   * @type List
   */
  public $domainPlanification;

  /*
   * @type String
   */
  public $id;

  /*
   * @type String
   */
  public $description;

  /*
   * @type JobKind
   */
  public $kind;

  /*
   * @type boolean
   */
  public $sendReport;

  /*
   * @type String
   */
  public $recipients;

  /*
   * Constructor
   */
  public function __construct() {
    $this->domainStatus =  array();
    $this->domainPlanification =  array();
    $this->id = "";
    $this->description = "";
    $this->sendReport = false;
    $this->recipients = "";
  }

  public function toMap() {
    $data = array(    
        "domainStatus" => empty($this->domainStatus) ? null : $this->domainStatus,    
        "domainPlanification" => empty($this->domainPlanification) ? null : $this->domainPlanification,    
        "id" => empty($this->id) ? null : $this->id,    
        "description" => empty($this->description) ? null : $this->description,    
        "kind" => empty($this->kind) ? null : $this->kind,    
        "sendReport" => empty($this->sendReport) ? null : $this->sendReport,    
        "recipients" => empty($this->recipients) ? null : $this->recipients);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
