<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * ItemUri.
 */
class ItemUri  {

  /*
   * @type String
   */
  public $containerUid;

  /*
   * @type String
   */
  public $itemUid;

  /*
   * Constructor
   */
  public function __construct() {
    $this->containerUid = "";
    $this->itemUid = "";
  }

  public function toMap() {
    $data = array(    
        "containerUid" => empty($this->containerUid) ? null : $this->containerUid,    
        "itemUid" => empty($this->itemUid) ? null : $this->itemUid);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
