<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * DirEntry.
 */
class DirEntry extends BaseDirEntry {

  /*
   * @type String
   */
  public $path;

  /*
   * @type String
   */
  public $email;

  /*
   * @type boolean
   */
  public $hidden;

  /*
   * @type boolean
   */
  public $system;

  /*
   * @type boolean
   */
  public $archived;

  /*
   * @type List
   */
  public $emails;

  /*
   * @type String
   */
  public $orgUnitUid;

  /*
   * @type OrgUnitPath
   */
  public $orgUnitPath;

  /*
   * @type String
   */
  public $dataLocation;

  /*
   * Constructor
   */
  public function __construct() {
  parent::__construct();    $this->path = "";
    $this->email = "";
    $this->hidden = false;
    $this->system = false;
    $this->archived = false;
    $this->emails =  array();
    $this->orgUnitUid = "";
    $this->orgUnitPath =   new OrgUnitPath();
    $this->dataLocation = "";
  }

  public function toMap() {
    $data = array(    
        "path" => empty($this->path) ? null : $this->path,    
        "email" => empty($this->email) ? null : $this->email,    
        "hidden" => empty($this->hidden) ? null : $this->hidden,    
        "system" => empty($this->system) ? null : $this->system,    
        "archived" => empty($this->archived) ? null : $this->archived,    
        "emails" => empty($this->emails) ? null : $this->emails,    
        "orgUnitUid" => empty($this->orgUnitUid) ? null : $this->orgUnitUid,    
        "orgUnitPath" => empty($this->orgUnitPath) ? null : $this->orgUnitPath,    
        "dataLocation" => empty($this->dataLocation) ? null : $this->dataLocation);
    return $data;
  }
  
  public function serialize() {
    $parentMap =  $parentMap = parent::toMap();;
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
